/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.statistics.distribution.DiscreteDistribution;
import net.doodleproject.numerics4j.statistics.distribution.SaddlePointExpansion;

public class NegativeBinomialDistribution
extends DiscreteDistribution {
    private int numberOfSuccesses;
    private double probabilityOfSuccess;

    public NegativeBinomialDistribution() {
        this(1, 0.5);
    }

    public NegativeBinomialDistribution(int r, double p) {
        this.setNumberOfSuccesses(r);
        this.setProbabilityOfSuccess(p);
    }

    @Override
    public double cumulativeProbability(int x) throws NumericException {
        double ret = x < -1 ? 0.0 : this.simpleCumulativeProbability(0, x);
        return ret;
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws NumericException {
        int ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Integer.MIN_VALUE : (p == 0.0 ? -1 : (p == 1.0 ? Integer.MAX_VALUE : this.findInverseCumulativeProbability(p, 0, (int)((double)this.numberOfSuccesses * this.probabilityOfSuccess + 0.5), Integer.MAX_VALUE)));
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret;
        if (x < 0) {
            ret = 0.0;
        } else {
            ret = Math.exp(SaddlePointExpansion.logBinomialProbability(this.numberOfSuccesses, x + this.numberOfSuccesses, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
            ret = (double)this.numberOfSuccesses * ret / (double)(x + this.numberOfSuccesses);
        }
        return ret;
    }

    public void setNumberOfSuccesses(int r) {
        if (r <= 0) {
            throw new IllegalArgumentException("number of successes must be positive.");
        }
        this.numberOfSuccesses = r;
    }

    public void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

