/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.series;

import net.doodleproject.numerics4j.IterativeMethod;
import net.doodleproject.numerics4j.exception.NumericException;

public abstract class Series
extends IterativeMethod {
    private int firstIndex;

    protected Series() {
        this(100, 1.0E-15);
    }

    protected Series(int iterations, double error) {
        this(0, iterations, error);
    }

    protected Series(int index, int iterations, double error) {
        super(iterations, error);
        this.setFirstIndex(index);
    }

    public double evaluate(double x) throws NumericException {
        IterativeState state = new IterativeState(x);
        this.iterate(state);
        return state.getResult();
    }

    protected abstract double getTerm(int var1, double var2);

    private int getFirstIndex() {
        return this.firstIndex;
    }

    private void setFirstIndex(int index) {
        this.firstIndex = index;
    }

    class IterativeState
    implements IterativeMethod.IterativeState {
        private double sum;
        private double term;
        private int n;
        private double x;

        IterativeState(double t) {
            this.x = t;
        }

        @Override
        public int getIterations() {
            return this.n;
        }

        @Override
        public double getRelativeError() {
            return this.sum / (this.sum - this.term) - 1.0;
        }

        @Override
        public void initialize() {
            this.sum = 0.0;
            this.n = Series.this.getFirstIndex();
        }

        @Override
        public void iterate() {
            this.term = Series.this.getTerm(this.n, this.x);
            ++this.n;
            this.sum += this.term;
        }

        double getResult() {
            this.iterate();
            return this.sum;
        }
    }
}

