/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.random;

import net.doodleproject.numerics4j.random.AbstractContinuousRandomVariable;
import net.doodleproject.numerics4j.random.ContinuousRandomVariable;
import net.doodleproject.numerics4j.random.RNG;
import net.doodleproject.numerics4j.random.RandomRNG;

public class GammaRandomVariable
extends AbstractContinuousRandomVariable {
    private double alpha;
    private double beta;
    private ContinuousRandomVariable strategy;

    public GammaRandomVariable() {
        this(1.0, 1.0);
    }

    public GammaRandomVariable(double a, double b) {
        this(a, b, new RandomRNG());
    }

    public GammaRandomVariable(double a, double b, RNG source) {
        super(source);
        this.setAlpha(a);
        this.setBeta(b);
    }

    public static double nextRandomVariable(double a, double b, RNG source) {
        double x = a <= 1.0 ? GammaRandomVariable.nextRandomVariableSmallAlpha(a, b, source) : GammaRandomVariable.nextRandomVariableLargeAlpha(a, b, source);
        return x;
    }

    private static double nextRandomVariableLargeAlpha(double a, double b, RNG source) {
        double d = a - 1.0;
        double c = 3.0 * a - 0.75;
        boolean accepted = false;
        double x = 0.0;
        do {
            double u = source.nextRandomNumber();
            double v = source.nextRandomNumber();
            double w = u * (1.0 - u);
            double y = Math.sqrt(c / w) * (u - 0.5);
            x = d + y;
            if (!(x >= 0.0)) continue;
            double z = 64.0 * w * w * w * v * v;
            boolean bl = accepted = z <= 1.0 - 2.0 * y * y / x || Math.log(z) <= 2.0 * (d * Math.log(x / d) - y);
        } while (!accepted);
        return b * x;
    }

    private static double nextRandomVariableSmallAlpha(double a, double b, RNG source) {
        double x;
        boolean rejected = false;
        do {
            double u0 = source.nextRandomNumber();
            double u1 = source.nextRandomNumber();
            if (u0 <= Math.E / (Math.E + a)) {
                x = Math.pow((Math.E + a) * u0 / Math.E, 1.0 / a);
                rejected = u1 > Math.exp(-x);
                continue;
            }
            x = -Math.log((Math.E + a) * (1.0 - u0) / (a * Math.E));
            boolean bl = rejected = u1 > Math.pow(x, a - 1.0);
        } while (rejected);
        return b * x;
    }

    private double getAlpha() {
        return this.alpha;
    }

    private double getBeta() {
        return this.beta;
    }

    @Override
    public double nextRandomVariable() {
        return this.strategy.nextRandomVariable();
    }

    private void setAlpha(double a) {
        if (a <= 0.0 || Double.isNaN(a)) {
            throw new IllegalArgumentException("Alpha must be positive.");
        }
        this.alpha = a;
        this.strategy = this.alpha <= 1.0 ? new ContinuousRandomVariable(){

            @Override
            public double nextRandomVariable() {
                return GammaRandomVariable.nextRandomVariableSmallAlpha(GammaRandomVariable.this.getAlpha(), GammaRandomVariable.this.getBeta(), GammaRandomVariable.this.getSource());
            }
        } : new ContinuousRandomVariable(){

            @Override
            public double nextRandomVariable() {
                return GammaRandomVariable.nextRandomVariableLargeAlpha(GammaRandomVariable.this.getAlpha(), GammaRandomVariable.this.getBeta(), GammaRandomVariable.this.getSource());
            }
        };
    }

    private void setBeta(double b) {
        if (b <= 0.0 || Double.isNaN(b)) {
            throw new IllegalArgumentException("Beta must be positive.");
        }
        this.beta = b;
    }
}

