/*
 * Decompiled with CFR 0.152.
 */
package jmatmain;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jmatmain.SetEnv;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rsyntaxtextarea.modes.MatlabTokenMaker;
import org.fife.ui.rtextarea.RTextScrollPane;

public class mainGUI
extends JPanel {
    private RSyntaxTextArea textArea;
    private RTextScrollPane sp;
    private static final long serialVersionUID = 1L;

    public mainGUI(boolean isPopup) {
        this.setLayout(new BorderLayout());
        RSyntaxDocument syns = new RSyntaxDocument("text/plain");
        syns.setSyntaxStyle(new MatlabTokenMaker());
        this.textArea = new RSyntaxTextArea(syns);
        this.textArea.setCodeFoldingEnabled(false);
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setFont(SetEnv.globalFont);
        this.sp = new RTextScrollPane(this.textArea);
        this.sp.setFoldIndicatorEnabled(false);
        if (isPopup) {
            JPopupMenu popup = this.textArea.getPopupMenu();
            popup.addSeparator();
            popup.add(new JMenuItem(new OpenFileAction()));
            this.textArea.setCodeFoldingEnabled(true);
            this.sp.setFoldIndicatorEnabled(true);
        }
        this.add(this.sp);
    }

    public void loadFile(File file) {
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, file.getAbsolutePath() + " is a directory", "Error", 0);
            return;
        }
        if (!file.isFile()) {
            JOptionPane.showMessageDialog(this, "No such file: " + file.getAbsolutePath(), "Error", 0);
            return;
        }
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            this.textArea.read(r, null);
            r.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            UIManager.getLookAndFeel().provideErrorFeedback(this.textArea);
        }
    }

    private void changeStyleViaThemeXml() {
        try {
            Theme theme = Theme.load(this.getClass().getResourceAsStream("/eclipse_theme.xml"));
            theme.apply(this.textArea);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void setFont(RSyntaxTextArea textArea, Font font) {
        if (font != null) {
            SyntaxScheme ss = textArea.getSyntaxScheme();
            ss = (SyntaxScheme)ss.clone();
            for (int i = 0; i < ss.getStyleCount(); ++i) {
                if (ss.getStyle(i) == null) continue;
                ss.getStyle((int)i).font = font;
            }
            textArea.setSyntaxScheme(ss);
            textArea.setFont(font);
        }
    }

    public RTextScrollPane getScrollPane() {
        return this.sp;
    }

    public RSyntaxTextArea getEditor() {
        return this.textArea;
    }

    private class OpenFileAction
    extends TextAction {
        public OpenFileAction() {
            super("Open File");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent tc = this.getTextComponent(e);
            String filename = null;
            try {
                int selStart = tc.getSelectionStart();
                int selEnd = tc.getSelectionEnd();
                filename = selStart != selEnd ? tc.getText(selStart, selEnd - selStart) : this.getFilenameAtCaret(tc);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                UIManager.getLookAndFeel().provideErrorFeedback(tc);
                return;
            }
            mainGUI.this.loadFile(new File(filename));
        }

        public String getFilenameAtCaret(JTextComponent tc) throws BadLocationException {
            char ch;
            int end;
            int caret;
            char ch2;
            int start;
            Document doc = tc.getDocument();
            for (start = caret = tc.getCaretPosition(); start > 0 && this.isFilenameChar(ch2 = doc.getText(start - 1, 1).charAt(0)); --start) {
            }
            for (end = caret; end < doc.getLength() && this.isFilenameChar(ch = doc.getText(end, 1).charAt(0)); ++end) {
            }
            return doc.getText(start, end - start);
        }

        public boolean isFilenameChar(char ch) {
            return Character.isLetterOrDigit(ch) || ch == ':' || ch == '.' || ch == File.separatorChar;
        }
    }
}

