/*
 * Decompiled with CFR 0.152.
 */
package jmathlab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jmathlab.ConsoleKeyHandler;
import jmathlab.JPrompt;
import jmathlab.JasymcaSyntaxDocument;
import jmatmain.SetEnv;

public class Console
extends JTextPane {
    private JasymcaSyntaxDocument doc;
    private static final long serialVersionUID = 1L;
    int commandNo = 0;
    private Vector<String> previousCommands = new Vector(10, 10);
    int lineStart = this.getText().length() + 1;
    private JPrompt callerClass;
    private final String welcome = "\n";

    public Console(JPrompt gui) {
        this.callerClass = gui;
        ConsoleKeyHandler keyHandler = new ConsoleKeyHandler();
        this.addKeyListener(keyHandler);
        this.setLayout(new BorderLayout());
        this.doc = new JasymcaSyntaxDocument();
        this.setDocument(this.doc);
        this.setCaretColor(Color.red);
        this.setFont(SetEnv.globalFont);
        this.setText("\n");
    }

    @Override
    public void addKeyListener(KeyListener keyHandler) {
        super.addKeyListener(keyHandler);
    }

    public void prevCommand() {
        --this.commandNo;
        String text = "";
        if (this.commandNo >= 0 && this.commandNo < this.previousCommands.size()) {
            text = this.previousCommands.elementAt(this.commandNo).trim();
        } else if (this.commandNo < 0) {
            text = "";
            this.commandNo = -1;
        }
        String textArea = this.getText();
        int pos1 = textArea.lastIndexOf("> ") + 2;
        this.setText(textArea.substring(0, pos1) + text);
        this.setCaretPosition(this.getText().length());
    }

    public void nextCommand() {
        ++this.commandNo;
        String text = "";
        if (this.commandNo >= 0 && this.commandNo < this.previousCommands.size()) {
            text = this.previousCommands.elementAt(this.commandNo).trim();
        } else if (this.commandNo >= this.previousCommands.size()) {
            text = "";
            this.commandNo = this.previousCommands.size();
        }
        String textArea = this.getText();
        int pos1 = textArea.lastIndexOf("> ") + 2;
        this.setText(textArea.substring(0, pos1) + text);
        this.setCaretPosition(this.getText().length());
    }

    public void checkPosition() {
        if (this.getCaretPosition() < this.lineStart) {
            this.setCaretPosition(this.lineStart);
        }
    }

    public void home() {
        this.setCaretPosition(this.lineStart - 1);
    }

    public void end() {
        this.setCaretPosition(this.getText().length());
    }

    public void interpretLine() {
        String text = this.getText();
        String inputString = text.substring(text.lastIndexOf("> ") + 2, text.length());
        if (inputString.equals("quit") || inputString.equals("exit") || inputString.equals("clear")) {
            this.callerClass.clear();
        }
        this.append("\n");
        this.callerClass.interpretLine(inputString);
        this.previousCommands.addElement(inputString);
        this.commandNo = this.previousCommands.size();
    }

    public void displayPrompt() {
        this.append("> ");
        this.lineStart = this.getText().length();
        this.setCaretPosition(this.lineStart);
    }

    public void newLine() {
        this.append("\n");
    }

    public void displayText(String text) {
        this.doc.setHighlighting(false);
        this.append(text + "\n");
        this.doc.setHighlighting(true);
    }

    public JTextPane getComponent() {
        return this;
    }

    public void clear() {
        this.setText("\n");
        this.displayPrompt();
    }

    public void append(String s) {
        try {
            Document doc = this.getDocument();
            doc.insertString(doc.getLength(), s, null);
        }
        catch (BadLocationException exc) {
            exc.printStackTrace();
        }
    }
}

