/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Constant;
import jasymca.JasymcaException;
import jasymca.Polynomial;
import jasymca.Variable;
import jasymca.Zahl;

public class SimpleVariable
extends Variable {
    String name;
    static SimpleVariable top = new SimpleVariable("top");

    public SimpleVariable(String name) {
        this.name = name.intern();
    }

    @Override
    public Algebraic deriv(Variable x) {
        if (this.equals(x)) {
            return Zahl.ONE;
        }
        return Zahl.ZERO;
    }

    @Override
    public boolean equals(Object x) {
        return x instanceof SimpleVariable && ((SimpleVariable)x).name.equals(this.name);
    }

    public String toString() {
        return this.name;
    }

    public Object toPrefix() {
        return this.name;
    }

    @Override
    public boolean smaller(Variable v) {
        if (v == top) {
            return true;
        }
        if (this == top) {
            return false;
        }
        if (v instanceof Constant) {
            return false;
        }
        if (!(v instanceof SimpleVariable)) {
            return true;
        }
        return this.name.compareTo(((SimpleVariable)v).name) < 0;
    }

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        if (var.equals(this)) {
            return x;
        }
        return new Polynomial(this);
    }
}

