/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Constants;
import jasymca.Environment;
import jasymca.Index;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaLOADFILE;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.io.PrintStream;
import java.util.List;
import java.util.Stack;
import jhplot.H1D;
import jhplot.H2D;

public class Processor
implements Constants {
    public Stack stack = new Stack();
    public Environment env;
    public PrintStream ps = null;
    boolean interrupt_flag = false;
    static final int LIST = 1;
    static final int MATRIX = 2;
    static final int SCALAR = 3;
    static final int STRING = 4;
    static final int FUNCTION = 5;
    static final int LVALUE = 6;
    static final int SYMBOL = 7;
    static final int NARG = 8;
    static final int PDIR = 9;
    static final int COLON = 10;
    static final int SYMREF = 11;
    static final int H1D = 20;
    static final int H2D = 21;
    static final int BREAK = 1;
    static final int CONTINUE = 2;
    static final int RETURN = 3;
    static final int EXIT = 4;
    static final int ERROR = 5;

    public Processor(Environment env) {
        this.env = env;
        Lambda.pc = this;
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    Environment getEnvironment() {
        return this.env;
    }

    public void setPrintStream(PrintStream ps) {
        this.ps = ps;
    }

    boolean check_interrupt() {
        return this.interrupt_flag;
    }

    void set_interrupt(boolean flag) {
        this.interrupt_flag = flag;
    }

    int instruction_type(Object x) {
        if (x instanceof List) {
            return 1;
        }
        if (x instanceof Matrix || x instanceof Vektor) {
            return 2;
        }
        if (x instanceof H1D) {
            return 20;
        }
        if (x instanceof H2D) {
            return 21;
        }
        if (x instanceof Algebraic) {
            return 3;
        }
        if (x.equals(":")) {
            return 10;
        }
        if (x instanceof String) {
            String s = (String)x;
            switch (s.charAt(0)) {
                case '@': {
                    return 11;
                }
                case ' ': {
                    return 4;
                }
                case '$': {
                    return 6;
                }
                case '#': {
                    return 9;
                }
            }
            return 7;
        }
        if (x instanceof Integer) {
            return 8;
        }
        if (x instanceof Lambda) {
            return 5;
        }
        return 0;
    }

    public int process_instruction(Object x, boolean canon) throws ParseException, JasymcaException {
        if (this.interrupt_flag) {
            this.set_interrupt(false);
            throw new JasymcaException("Interrupted.");
        }
        switch (this.instruction_type(x)) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                this.stack.push(x);
                return 0;
            }
            case 2: {
                this.stack.push(x);
                return 0;
            }
            case 5: {
                return ((Lambda)x).lambda(this.stack);
            }
            case 11: {
                String s = ((String)x).substring(1);
                Object val = this.env.getValue(s);
                if (val == null) {
                    try {
                        LambdaLOADFILE.readFile(s + ".m");
                        val = this.env.getValue(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (val instanceof Lambda) {
                    return ((Lambda)val).lambda(this.stack);
                }
                if (val instanceof Algebraic) {
                    Matrix mx = new Matrix((Algebraic)val);
                    Index idx = Index.createIndex(this.stack, mx);
                    mx = mx.extract(idx);
                    this.stack.push(mx.reduce());
                    return 0;
                }
                if (val instanceof String && ((String)val).length() > 1) {
                    s = ((String)val).substring(1);
                    if ((val = this.env.getValue(s)) == null) {
                        try {
                            LambdaLOADFILE.readFile(s + ".m");
                            val = this.env.getValue(s);
                        }
                        catch (Exception mx) {
                            // empty catch block
                        }
                    }
                    if (val instanceof Lambda) {
                        return ((Lambda)val).lambda(this.stack);
                    }
                }
                throw new ParseException("Unknown symbol or incorrect symbol type: " + x);
            }
            case 7: {
                Object val = this.env.getValue((String)x);
                if (val == null) {
                    try {
                        LambdaLOADFILE.readFile((String)x + ".m");
                        return 0;
                    }
                    catch (Exception e) {
                        throw new ParseException("Unknown symbol: " + x);
                    }
                }
                return this.process_instruction(val, canon);
            }
            case 9: {
                String selector = ((String)x).substring(1);
                if (selector.equals(";")) {
                    this.clearStack();
                } else if (selector.equals(",")) {
                    this.printStack();
                } else {
                    int nout;
                    if (selector.equals("brk")) {
                        return 1;
                    }
                    if (selector.equals("exit")) {
                        return 4;
                    }
                    if (selector.equals("cont")) {
                        return 2;
                    }
                    if (selector.equals("ret")) {
                        return 3;
                    }
                    Lambda.length = nout = Integer.parseInt(selector);
                }
                return 0;
            }
        }
        throw new JasymcaException("Unrecognized instruction type: " + x);
    }

    public synchronized int process_list(List x, boolean canon) throws JasymcaException, ParseException {
        int n = x.size();
        int i = 0;
        try {
            for (i = 0; i < n; ++i) {
                Object z = x.get(i);
                int ret = this.process_instruction(z, canon);
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
        catch (ParseException p) {
            throw p;
        }
        catch (JasymcaException j) {
            throw j;
        }
    }

    void clearStack() {
        while (!this.stack.empty()) {
            Object x = this.stack.pop();
            if (this.stack.size() != 0 || !(x instanceof Algebraic)) continue;
            this.env.putValue("ans", x);
        }
    }

    public void printStack() {
        while (!this.stack.empty()) {
            Object x = this.stack.pop();
            if (x instanceof Algebraic) {
                String vname = "ans";
                this.env.putValue(vname, x);
                if (((Algebraic)x).name != null) {
                    vname = ((Algebraic)x).name;
                }
                if (this.ps == null) continue;
                String s = vname + " = ";
                this.ps.print(s);
                ((Algebraic)x).print(this.ps);
                this.ps.println("");
                continue;
            }
            if (!(x instanceof String)) continue;
            this.ps.println((String)x);
        }
    }
}

