/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Comp;
import jasymca.Constants;
import jasymca.Environment;
import jasymca.Exakt;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.ParserState;
import jasymca.Rule;
import jasymca.Unexakt;
import jasymca.Zahl;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;

public abstract class Parser
implements Constants {
    static final Integer ONE = new Integer(1);
    static final Integer TWO = new Integer(2);
    static final Integer THREE = new Integer(3);
    ParserState pst;
    Vector nonsymbols = new Vector();
    static String[] listsep = new String[]{",", ";"};
    static String[] stringops = new String[]{"=", ","};

    Parser(Environment env) {
    }

    abstract void translate(String var1) throws ParseException;

    abstract boolean ready();

    abstract List get() throws ParseException;

    public abstract List compile(InputStream var1, PrintStream var2) throws ParseException, IOException;

    public abstract List compile(String var1) throws ParseException;

    public abstract String prompt();

    abstract List compile_expr(List var1) throws ParseException;

    abstract List compile_statement(List var1) throws ParseException;

    abstract List compile_lval(List var1) throws ParseException;

    abstract List compile_list(List var1) throws ParseException;

    abstract List compile_func(List var1) throws ParseException;

    abstract boolean commandq(Object var1);

    List compile_command_args(List expr) {
        List s = Comp.vec2list(new Vector());
        for (int n = expr.size() - 1; n >= 0; --n) {
            Object x = expr.get(n);
            if (x instanceof Algebraic) {
                s.add(x);
                continue;
            }
            if (this.symbolq(x)) {
                s.add("$" + x);
                continue;
            }
            if (this.stringq(x)) {
                s.add("$" + ((String)x).substring(1));
                continue;
            }
            if (!(x instanceof Vector)) continue;
            s.addAll(this.compile_command_args((List)x));
        }
        return s;
    }

    void reset() {
        this.pst = new ParserState(null, 0);
    }

    Rule[] compile_rules(String[][] s) throws ParseException {
        Rule[] r = new Rule[s.length];
        for (int i = 0; i < s.length; ++i) {
            Rule r1 = new Rule();
            this.reset();
            this.translate(s[i][0]);
            r1.rule_in = this.pst.tokens;
            this.reset();
            this.translate(s[i][1]);
            r1.rule_out = this.pst.tokens;
            r[i] = r1;
        }
        return r;
    }

    List compile_command(List expr) {
        if (expr == null || expr.size() == 0 || !this.commandq(expr.get(0))) {
            return null;
        }
        List s = this.compile_command_args(expr.subList(1, expr.size()));
        s.add(new Integer(s.size()));
        try {
            String command = (String)expr.get(0);
            Class<?> c = Class.forName("jasymca.Lambda" + command.toUpperCase());
            s.add((Lambda)c.newInstance());
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean symbolq(Object expr) {
        return expr instanceof String && ((String)expr).length() > 0 && ((String)expr).charAt(0) != ' ' && !this.nonsymbols.contains(expr);
    }

    boolean stringq(Object expr) {
        return expr instanceof String && ((String)expr).length() > 0 && ((String)expr).charAt(0) == ' ';
    }

    static boolean oneof(char c, String s) {
        return s.indexOf(c) != -1;
    }

    static boolean oneof(Object c, String s) {
        return c instanceof String && ((String)c).length() > 0 && Parser.oneof(((String)c).charAt(0), s);
    }

    static boolean oneof(Object c, Object[] d) {
        for (int i = 0; i < d.length; ++i) {
            if (!d[i].equals(c)) continue;
            return true;
        }
        return false;
    }

    static boolean whitespace(char c) {
        return Parser.oneof(c, " \t\n\r");
    }

    static void skipWhitespace(StringBuffer s) {
        int i;
        for (i = 0; i < s.length() && Parser.whitespace(s.charAt(i)); ++i) {
        }
        s.delete(0, i);
    }

    static int nextIndexOf(Object x, int idx, List list) {
        int n = list.size();
        while (idx < n) {
            if (x.equals(list.get(idx))) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    static Zahl readNumber(StringBuffer s) throws ParseException {
        int kmax;
        for (kmax = 0; kmax < s.length() && Parser.oneof(s.charAt(kmax), "0123456789.eE+-"); ++kmax) {
        }
        char[] substring = new char[kmax];
        s.getChars(0, kmax, substring, 0);
        String sub = new String(substring);
        for (int k = kmax; k > 0; --k) {
            try {
                String ts = sub.substring(0, k);
                double x = Double.parseDouble(ts);
                if (ts.endsWith(".") && s.length() > k && (s.charAt(k) == '^' || s.charAt(k) == '/')) continue;
                boolean imag = false;
                if (s.length() > k && (s.charAt(k) == 'i' || s.charAt(k) == 'j')) {
                    imag = true;
                    ++k;
                }
                s.delete(0, k);
                if (Math.abs(x) > 1.0E15) {
                    try {
                        BigInteger bi = new BigInteger(ts, 10);
                        return imag ? (Zahl)new Exakt(bi).mult(Zahl.IONE) : new Exakt(bi);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return imag ? new Unexakt(0.0, x) : new Unexakt(x);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Internal Error.");
    }

    static String cutstring(StringBuffer sb, char a, char b) throws ParseException {
        int i;
        sb.delete(0, 1);
        String s = sb.toString();
        int cnt = 1;
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (a != b && c == a) {
                ++cnt;
            } else if (c == b) {
                --cnt;
            }
            if (cnt == 0) break;
        }
        if (cnt != 0) {
            throw new ParseException("Unclosed " + a);
        }
        s = s.substring(0, i);
        sb.delete(0, i + 1);
        return s;
    }

    static boolean stringopq(Object x) {
        return Parser.oneof(x, stringops);
    }

    static boolean number(char c) {
        return Parser.oneof(c, "0123456789");
    }

    static String readLine(InputStream is) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = is.read()) != -1) {
            sb.append((char)c);
            if (c != 10 && c != 13) continue;
            return sb.toString();
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }
}

