/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Comp;
import jasymca.Compiler;
import jasymca.CreateVector;
import jasymca.Environment;
import jasymca.Lambda;
import jasymca.Operator;
import jasymca.ParseException;
import jasymca.Parser;
import jasymca.ParserState;
import jasymca.REFX;
import jasymca.Rule;
import jasymca.Unexakt;
import jasymca.Zahl;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Vector;

class MaximaParser
extends Parser {
    Lambda CRV = new CreateVector();
    Lambda REF = new REFX();
    int IN_PARENT = 1;
    int IN_BRACK = 2;
    int IN_BLOCK = 4;
    Rule[] rules;
    String[][] rules_in = new String[][]{{"for u step v thru w do ( X )", "X w v u 4 XFOR"}, {"while u do ( X )", "X u 2 WHILE"}, {"if u then ( X ) else ( Y )", "Y X u 3 BRANCH"}, {"if u then ( X )", "X u 2 BRANCH"}};
    String[] commands = new String[]{"format", "hold", "clear", "addpath"};
    int prompt = 1;
    static String FOR = "for";
    static String WHILE = "while";
    static String IF = "if";
    static String THEN = "then";
    static String ELSE = "else";
    static String BREAK = "break";
    static String RETURN = "return";
    static String CONTINUE = "continue";
    static String EXIT = "exit";
    static String STEP = "step";
    static String THRU = "thru";
    static String DO = "do";
    private String[] keywords = new String[]{FOR, WHILE, IF, THEN, ELSE, BREAK, RETURN, CONTINUE, EXIT, STEP, THRU, DO};
    private String sepright = ")]+-*/^!,;:=.<>'\\";
    private String separator = "()[]\n\t\r +-*/^!,;:=.<>'\\&|";

    public MaximaParser(Environment env) {
        super(env);
        int i;
        env.addPath(".");
        Environment.globals.put("pi", Zahl.PI);
        Environment.globals.put("i", Zahl.IONE);
        Environment.globals.put("j", Zahl.IONE);
        Environment.globals.put("eps", new Unexakt(2.220446049250313E-16));
        Environment.globals.put("ratepsilon", new Unexakt(2.0E-8));
        Environment.globals.put("algepsilon", new Unexakt(1.0E-8));
        Environment.globals.put("rombergit", new Unexakt(11.0));
        Environment.globals.put("rombergtol", new Unexakt(1.0E-4));
        this.pst = new ParserState(null, 0);
        Operator.OPS = new Operator[]{new Operator("PPR", "++", 1, 1, 9), new Operator("MMR", "--", 1, 1, 9), new Operator("PPL", "++", 1, 0, 9), new Operator("MML", "--", 1, 0, 9), new Operator("MPW", "^^", 1, 0, 2), new Operator("POW", "**", 1, 0, 2), new Operator("FCN", ":=", 10, 1, 26), new Operator("POW", "^", 1, 0, 2), new Operator("EQU", "==", 6, 0, 2), new Operator("NEQ", "!=", 6, 0, 2), new Operator("GEQ", ">=", 6, 0, 2), new Operator("LEQ", "<=", 6, 0, 2), new Operator("DIV", "/", 3, 0, 2), new Operator("SUB", "=", 5, 0, 2), new Operator("GRE", ">", 6, 0, 2), new Operator("LES", "<", 6, 0, 2), new Operator("OR", "|", 9, 0, 2), new Operator("NOT", "~", 8, 0, 1), new Operator("AND", "&", 7, 0, 2), new Operator("ASS", ":", 10, 1, 10), new Operator("ADD", "+", 4, 0, 3), new Operator("SUB", "-", 4, 0, 3), new Operator("MMU", ".", 3, 0, 2), new Operator("MUL", "*", 3, 0, 2), new Operator("MDR", "/", 3, 0, 2), new Operator("MDL", "\\", 3, 0, 2), new Operator("ADJ", "'", 1, 1, 1), new Operator("FCT", "!", 1, 1, 1)};
        for (i = 0; i < Operator.OPS.length; ++i) {
            this.nonsymbols.addElement(Operator.OPS[i].symbol);
        }
        for (i = 0; i < listsep.length; ++i) {
            this.nonsymbols.addElement(listsep[i]);
        }
        for (i = 0; i < this.commands.length; ++i) {
            this.nonsymbols.addElement(this.commands[i]);
        }
        for (i = 0; i < this.keywords.length; ++i) {
            this.nonsymbols.addElement(this.keywords[i]);
        }
        try {
            this.rules = this.compile_rules(this.rules_in);
        }
        catch (ParseException p) {
            System.out.println("Failed to compile rules.");
        }
        Lambda.pr = this;
    }

    @Override
    public String prompt() {
        return "(c" + this.prompt++ + ") ";
    }

    @Override
    public List compile(InputStream is, PrintStream ps) throws ParseException, IOException {
        String s;
        String sp = null;
        this.reset();
        while ((s = MaximaParser.readLine(is)) != null) {
            sp = s;
            this.translate(s);
            if (this.ready()) break;
            if (ps == null) continue;
            ps.print("> ");
        }
        if (sp == null) {
            return null;
        }
        if (s == null && this.pst.inList == this.IN_BLOCK) {
            List v = this.pst.tokens;
            this.pst = (ParserState)this.pst.sub;
            this.pst.tokens.add(v);
        }
        return this.get();
    }

    @Override
    public List compile(String s) throws ParseException {
        this.reset();
        this.translate(s);
        return this.get();
    }

    @Override
    List get() throws ParseException {
        List r = this.pst.tokens;
        List pgm = this.compile_statement(r);
        if (pgm != null) {
            return pgm;
        }
        throw new ParseException("Compilation failed.");
    }

    @Override
    void translate(String s) throws ParseException {
        Object t;
        if (s == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(s);
        while ((t = this.nextToken(sb)) != null) {
            this.pst.tokens.add(t);
            this.pst.prev = t;
        }
    }

    public Object nextToken(StringBuffer s) throws ParseException {
        MaximaParser.skipWhitespace(s);
        if (s.length() < 1) {
            return null;
        }
        char c0 = s.charAt(0);
        switch (c0) {
            case '\"': {
                return ' ' + MaximaParser.cutstring(s, '\"', '\"');
            }
            case '(': {
                this.pst = new ParserState(this.pst, this.IN_PARENT);
                return this.nextToken(s.delete(0, 1));
            }
            case ')': {
                if (this.pst.inList == this.IN_BRACK) {
                    throw new ParseException("Wrong parenthesis.");
                }
                while (this.pst.inList == this.IN_BLOCK) {
                    List v = this.pst.tokens;
                    this.pst = (ParserState)this.pst.sub;
                    this.pst.tokens.add(v);
                }
                if (this.pst.inList != this.IN_PARENT) {
                    throw new ParseException("Wrong parenthesis.");
                }
                List t = this.pst.tokens;
                this.pst = (ParserState)this.pst.sub;
                s.delete(0, 1);
                return t;
            }
            case '[': {
                this.pst = new ParserState(this.pst, this.IN_BRACK);
                return this.nextToken(s.delete(0, 1));
            }
            case ']': {
                if (this.pst.inList != this.IN_BRACK) {
                    throw new ParseException("Wrong brackets.");
                }
                List t = this.pst.tokens;
                while (t.size() > 0 && ";".equals(t.get(t.size() - 1))) {
                    t.remove(t.size() - 1);
                }
                t.add(0, "[");
                this.pst = (ParserState)this.pst.sub;
                s.delete(0, 1);
                return t;
            }
            case '#': 
            case '%': {
                s.delete(0, s.length());
                return null;
            }
            case '\'': {
                if (this.pst.prev == null || MaximaParser.stringopq(this.pst.prev)) {
                    return ' ' + MaximaParser.cutstring(s, '\'', '\'');
                }
                return this.readString(s);
            }
            case ',': {
                s.delete(0, 1);
                return "" + c0;
            }
            case ';': {
                this.closeBlocks();
                s.delete(0, 1);
                return "" + c0;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return MaximaParser.readNumber(s);
            }
            case '.': {
                if (s.length() > 1 && MaximaParser.number(s.charAt(1))) {
                    return MaximaParser.readNumber(s);
                }
                return this.readString(s);
            }
        }
        return this.readString(s);
    }

    void closeBlocks() throws ParseException {
        while (this.pst.inList != 0) {
            if (this.pst.inList == this.IN_BRACK || this.pst.inList == this.IN_PARENT) {
                throw new ParseException("Unclosed brackets or parenthesis.");
            }
            if (this.pst.inList != this.IN_BLOCK) continue;
            List v = this.pst.tokens;
            this.pst = (ParserState)this.pst.sub;
            this.pst.tokens.add(v);
        }
    }

    @Override
    boolean ready() {
        return this.pst.tokens.size() != 0 && ";".equals(this.pst.tokens.get(this.pst.tokens.size() - 1));
    }

    Object readString(StringBuffer s) throws ParseException {
        int k;
        int len = s.length() > 1 ? 2 : s.length();
        char[] substring = new char[len];
        s.getChars(0, len, substring, 0);
        String st = new String(substring);
        Operator op = Operator.get(st);
        if (op != null) {
            s.delete(0, op.symbol.length());
            return op.symbol;
        }
        for (k = 1; k < s.length() && !MaximaParser.oneof(s.charAt(k), this.separator); ++k) {
        }
        substring = new char[k];
        s.getChars(0, k, substring, 0);
        String t = new String(substring);
        s.delete(0, k);
        if (t.equals(IF) || t.equals(FOR) || t.equals(WHILE)) {
            if (this.pst.inList == this.IN_BRACK) {
                throw new ParseException("Block starts within vector.");
            }
            this.pst.tokens.add(t);
            this.pst = new ParserState(this.pst, this.IN_BLOCK);
            return this.nextToken(s);
        }
        if (t.equals(STEP) | t.equals(THRU)) {
            if (this.pst.inList != this.IN_BLOCK) {
                throw new ParseException("Orphaned " + t);
            }
            List v = this.pst.tokens;
            ((ParserState)this.pst.sub).tokens.add(v);
            this.pst = new ParserState(this.pst.sub, this.IN_BLOCK);
            return ELSE;
        }
        if (t.equals(THEN) || t.equals(DO)) {
            if (this.pst.inList != this.IN_BLOCK) {
                throw new ParseException("Orphaned " + t);
            }
            List v = this.pst.tokens;
            ((ParserState)this.pst.sub).tokens.add(v);
            this.pst = (ParserState)this.pst.sub;
            return t;
        }
        return t;
    }

    boolean expressionq(Object expr) {
        return expr != null && !this.operatorq(expr);
    }

    boolean operatorq(Object expr) {
        return Operator.get(expr) != null;
    }

    List compile_unary(Operator op, List expr) throws ParseException {
        List arg;
        List arg_in = op.left_right() ? expr.subList(1, expr.size()) : expr.subList(0, expr.size() - 1);
        List list = arg = op.lvalue() ? this.compile_lval(arg_in) : this.compile_expr(arg_in);
        if (arg == null) {
            return null;
        }
        arg.add(ONE);
        arg.add(op.getLambda());
        return arg;
    }

    List compile_ternary(Operator op, List expr, int k) throws ParseException {
        int n = expr.size();
        for (int k0 = k + 2; k0 < n - 1; ++k0) {
            List right_in;
            List right;
            List mid_in;
            List mid;
            List left_in;
            List left;
            if (!op.symbol.equals(expr.get(k0)) || (left = this.compile_expr(left_in = expr.subList(0, k))) == null || (mid = this.compile_expr(mid_in = expr.subList(k + 1, k0))) == null || (right = this.compile_expr(right_in = expr.subList(k0 + 1, expr.size()))) == null) continue;
            left.addAll(mid);
            left.addAll(right);
            left.add(THREE);
            left.add(op.getLambda());
            return left;
        }
        return null;
    }

    List compile_binary(Operator op, List expr, int k) throws ParseException {
        List left;
        List left_in = expr.subList(0, k);
        List list = left = op.lvalue() ? this.compile_lval(left_in) : this.compile_expr(left_in);
        if (left == null) {
            return null;
        }
        List right_in = expr.subList(k + 1, expr.size());
        List right = this.compile_expr(right_in);
        if (right == null) {
            return null;
        }
        Integer nargs = TWO;
        if (op.lvalue()) {
            nargs = ONE;
        }
        if (op.list()) {
            left.add(right);
        } else {
            left.addAll(right);
        }
        left.add(nargs);
        left.add(op.getLambda());
        return left;
    }

    List translate_op(List expr) throws ParseException {
        int n = expr.size();
        for (int pred = 10; pred >= 0; --pred) {
            for (int i = 0; i < n; ++i) {
                List s;
                Operator op;
                int k = i;
                if (pred != 5) {
                    k = n - i - 1;
                }
                if ((op = Operator.get(expr.get(k), k == 0 ? 0 : (k == n - 1 ? 2 : 1))) == null || op.precedence != pred) continue;
                if (op.unary() && (k == 0 && op.left_right() || k == n - 1 && !op.left_right())) {
                    s = this.compile_unary(op, expr);
                    if (s == null) continue;
                    return s;
                }
                if (k > 0 && k < n - 3 && op.ternary() && (s = this.compile_ternary(op, expr, k)) != null) {
                    return s;
                }
                if (k <= 0 || k >= n - 1 || !op.binary() || (s = this.compile_binary(op, expr, k)) == null) continue;
                return s;
            }
        }
        return null;
    }

    List compile_vektor(List expr) throws ParseException {
        if (expr == null || expr.size() == 0 || !"[".equals(expr.get(0))) {
            return null;
        }
        expr = expr.subList(1, expr.size());
        List r = Comp.vec2list(new Vector());
        int nrow = 1;
        List x = expr;
        List xs = this.compile_list(x);
        if (xs == null) {
            return null;
        }
        xs.addAll(r);
        r = xs;
        r.add(new Integer(nrow));
        r.add(this.CRV);
        return r;
    }

    @Override
    List compile_list(List expr) throws ParseException {
        List xs;
        List x;
        int i;
        if (expr == null) {
            return null;
        }
        List r = Comp.vec2list(new Vector());
        if (expr.size() == 0) {
            r.add(new Integer(0));
            return r;
        }
        int ip = 0;
        int n = 1;
        while ((i = MaximaParser.nextIndexOf(",", ip, expr)) != -1) {
            x = expr.subList(ip, i);
            xs = this.compile_expr(x);
            if (xs == null) {
                return null;
            }
            xs.addAll(r);
            r = xs;
            ++n;
            ip = i + 1;
        }
        x = expr.subList(ip, expr.size());
        xs = this.compile_expr(x);
        if (xs == null) {
            return null;
        }
        xs.addAll(r);
        r = xs;
        r.add(new Integer(n));
        return r;
    }

    @Override
    List compile_lval(List expr) throws ParseException {
        int i;
        if (expr == null || expr.size() == 0) {
            return null;
        }
        List r = this.compile_lval1(expr);
        if (r != null) {
            return r;
        }
        if (expr.size() == 1) {
            if (expr.get(0) instanceof List) {
                return this.compile_lval((List)expr.get(0));
            }
            return null;
        }
        if (!"[".equals(expr.get(0))) {
            return null;
        }
        expr = expr.subList(1, expr.size());
        r = Comp.vec2list(new Vector());
        int n = 1;
        while ((i = expr.indexOf(",")) != -1) {
            List x = expr.subList(0, i);
            List xs = this.compile_lval1(x);
            if (xs == null) {
                return null;
            }
            xs.addAll(r);
            r = xs;
            expr = expr.subList(i + 1, expr.size());
            ++n;
        }
        List xs = this.compile_lval1(expr);
        if (xs == null) {
            return null;
        }
        xs.addAll(r);
        r = xs;
        r.add(0, new Integer(n));
        return r;
    }

    List compile_lval1(List expr) throws ParseException {
        if (expr == null) {
            return null;
        }
        switch (expr.size()) {
            case 1: {
                if (expr.get(0) instanceof List) {
                    return this.compile_lval1((List)expr.get(0));
                }
                if (this.symbolq(expr.get(0))) {
                    List s = Comp.vec2list(new Vector());
                    s.add("$" + expr.get(0));
                    return s;
                }
                return null;
            }
            case 2: {
                if (!this.symbolq(expr.get(0)) || !(expr.get(1) instanceof List)) {
                    return null;
                }
                List ref = this.compile_index((List)expr.get(1));
                if (ref == null) {
                    ref = this.compile_list((List)expr.get(1));
                }
                if (ref == null) {
                    return null;
                }
                ref.add("$" + expr.get(0));
                return ref;
            }
        }
        return null;
    }

    List compile_index(List expr) throws ParseException {
        if (expr.size() < 1 || !"[".equals(expr.get(0))) {
            return null;
        }
        return this.compile_list(expr.subList(1, expr.size()));
    }

    @Override
    boolean commandq(Object x) {
        return MaximaParser.oneof(x, this.commands);
    }

    @Override
    List compile_statement(List expr_in) throws ParseException {
        List expr_sub;
        List s;
        if (expr_in == null) {
            return null;
        }
        if (expr_in.size() == 0) {
            return Comp.vec2list(new Vector());
        }
        List expr = Comp.clonelist(expr_in);
        Object first = expr.get(0);
        for (int i = 0; i < this.rules.length; ++i) {
            Compiler c;
            Rule r = this.rules[i];
            if (!r.rule_in.get(0).equals(first) || expr.size() < r.rule_in.size() || (s = (c = new Compiler(r.rule_in, r.rule_out, this)).compile(expr_sub = expr.subList(0, r.rule_in.size()))) == null) continue;
            Comp.clear(expr, 0, expr_sub.size());
            if (expr.size() == 0) {
                return s;
            }
            List t = this.compile_statement(expr);
            if (t == null) {
                return null;
            }
            s.addAll(t);
            return s;
        }
        if (this.commandq(first)) {
            return this.compile_command(expr);
        }
        String lend = null;
        int ic = expr.indexOf(",");
        int is = expr.indexOf(";");
        if (ic >= 0 && (ic < is || is == -1)) {
            lend = "#,";
        } else if (is >= 0 && (is < ic || ic == -1)) {
            lend = "#;";
            ic = is;
        }
        if (ic == 0) {
            Comp.clear(expr, 0, 1);
            return this.compile_statement(expr);
        }
        if (lend != null) {
            expr_sub = expr.subList(0, ic);
            s = this.compile_expr(expr_sub);
            if (s != null) {
                s.add(lend);
                Comp.clear(expr, 0, ic + 1);
                if (expr.size() == 0) {
                    return s;
                }
                List t = this.compile_statement(expr);
                if (t == null) {
                    return null;
                }
                s.addAll(t);
                return s;
            }
        } else {
            return this.compile_expr(expr);
        }
        return null;
    }

    String compile_keyword(Object x) {
        if (x.equals(BREAK)) {
            return "#brk";
        }
        if (x.equals(CONTINUE)) {
            return "#cont";
        }
        if (x.equals(EXIT)) {
            return "#exit";
        }
        if (x.equals(RETURN)) {
            return "#ret";
        }
        return null;
    }

    @Override
    List compile_func(List expr) throws ParseException {
        if (expr.size() == 2) {
            List ref;
            Object op = expr.get(0);
            Object ref_in = expr.get(1);
            if (this.symbolq(op) && ref_in instanceof List && (ref = this.compile_list((List)ref_in)) != null) {
                ref.add(op);
                return ref;
            }
        }
        return null;
    }

    @Override
    List compile_expr(List expr) throws ParseException {
        List res;
        if (expr == null || expr.size() == 0) {
            return null;
        }
        if (expr.size() == 1) {
            Object x = expr.get(0);
            if (x instanceof Algebraic) {
                List s = Comp.vec2list(new Vector());
                s.add(x);
                return s;
            }
            if (x instanceof String) {
                String y = this.compile_keyword(x);
                if (y != null) {
                    List s = Comp.vec2list(new Vector());
                    s.add(y);
                    return s;
                }
                if (this.stringq(x) || this.symbolq(x)) {
                    List s = Comp.vec2list(new Vector());
                    s.add(x);
                    return s;
                }
                return null;
            }
            if (x instanceof List) {
                List xs = this.compile_vektor((List)x);
                if (xs != null) {
                    return xs;
                }
                return this.compile_expr((List)x);
            }
        }
        if (expr.size() == 2) {
            List ref;
            Object op = expr.get(0);
            Object ref_in = expr.get(1);
            if ("block".equals(op)) {
                List ref2;
                if (ref_in instanceof List && (ref2 = this.compile_statement((List)ref_in)) != null) {
                    List s = Comp.vec2list(new Vector());
                    s.add(ref2);
                    s.add(ONE);
                    s.add("BLOCK");
                    return s;
                }
                return null;
            }
            if (this.symbolq(op) && ref_in instanceof List && (ref = this.compile_list((List)ref_in)) != null) {
                ref.add(op);
                return ref;
            }
        }
        if ((res = this.translate_op(expr)) != null) {
            return res;
        }
        List left_in = expr.subList(0, expr.size() - 1);
        List left = this.compile_expr(left_in);
        if (left == null) {
            return null;
        }
        Object ref_in = expr.get(expr.size() - 1);
        if (!(ref_in instanceof List)) {
            return null;
        }
        List ref = this.compile_index((List)ref_in);
        if (ref != null) {
            ref.addAll(left);
            ref.add(TWO);
            ref.add(this.REF);
            return ref;
        }
        return null;
    }
}

