/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Unexakt;
import jasymca.Variable;
import java.util.Stack;

class LambdaTAYLOR
extends Lambda {
    LambdaTAYLOR() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaTAYLOR.getNarg(st);
        if (narg != 4) {
            throw new ParseException("Usage: TAYLOR (exp, var, pt, pow)");
        }
        Algebraic exp = LambdaTAYLOR.getAlgebraic(st);
        Variable v = LambdaTAYLOR.getVariable(st);
        Algebraic pt = LambdaTAYLOR.getAlgebraic(st);
        int n = LambdaTAYLOR.getInteger(st);
        Algebraic r = exp.value(v, pt);
        Algebraic t = new Polynomial(v).sub(pt);
        double nf = 1.0;
        for (int i = 1; i <= n; ++i) {
            exp = exp.deriv(v);
            r = r.add(exp.value(v, pt).mult(t.pow_n(i)).div(new Unexakt(nf *= (double)i)));
        }
        st.push(r);
        return 0;
    }
}

