/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.util.Stack;
import org.netlib.lapack.DGESDD;
import org.netlib.util.intW;

class LambdaSVD
extends LambdaAlgebraic {
    LambdaSVD() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        try {
            Class<?> clazz = Class.forName("org.netlib.lapack.DGESDD");
        }
        catch (ClassNotFoundException ce) {
            throw new JasymcaException("JLAPACK not available.");
        }
        int narg = LambdaSVD.getNarg(st);
        if (narg != 1) {
            throw new JasymcaException("Usage: SVD( A ).");
        }
        Matrix mx = new Matrix(LambdaSVD.getAlgebraic(st));
        double[][] a = mx.getDouble();
        int m = mx.nrow();
        int n = mx.ncol();
        double[] s = new double[Math.min(m, n)];
        String jobz = "A";
        double[][] u = new double[m][m];
        double[][] vt = new double[n][n];
        int lwork = 3 * Math.min(m, n) * Math.min(m, n) + Math.max(Math.max(m, n), 4 * Math.min(m, n) * Math.min(m, n) + 4 * Math.min(m, n));
        double[] work = new double[lwork];
        int[] iwork = new int[8 * Math.min(m, n)];
        intW info = new intW(1);
        DGESDD.DGESDD((String)jobz, (int)m, (int)n, (double[][])a, (double[])s, (double[][])u, (double[][])vt, (double[])work, (int)lwork, (int[])iwork, (intW)info);
        if (info.val != 0) {
            throw new JasymcaException("jlapack DGESDD failed.");
        }
        if (length == 1) {
            st.push(new Vektor(s).reduce());
        } else if (length == 3) {
            st.push(new Matrix(u).reduce());
            st.push(new Vektor(s).reduce());
            st.push(new Matrix(vt).reduce());
            length = 1;
        } else {
            throw new JasymcaException("Wrong number of output variables: " + length);
        }
        return 0;
    }
}

