/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;
import jhplot.math.num.random.RandomRNG;

class LambdaRANDOM
extends Lambda {
    LambdaRANDOM() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        Algebraic x;
        int narg = LambdaRANDOM.getNarg(st);
        if (narg != 1 && narg != 2) {
            throw new ParseException("requires 1 or 2 arguments: Dimension X and Y");
        }
        if (narg == 2) {
            x = LambdaRANDOM.getAlgebraic(st);
            Algebraic y = LambdaRANDOM.getAlgebraic(st);
            if (x instanceof Zahl && y instanceof Zahl) {
                int j1 = (int)((Zahl)x).unexakt().real;
                int j2 = (int)((Zahl)y).unexakt().real;
                RandomRNG p = new RandomRNG();
                double[][] d = new double[j1][j2];
                for (int i = 0; i < j1; ++i) {
                    for (int j = 0; j < j2; ++j) {
                        d[i][j] = p.nextRandomNumber();
                    }
                }
                Matrix m = new Matrix(d);
                st.push(m);
            }
        }
        if (narg == 1 && (x = LambdaRANDOM.getAlgebraic(st)) instanceof Zahl) {
            int j1 = (int)((Zahl)x).unexakt().real;
            RandomRNG p = new RandomRNG();
            double[] d = new double[j1];
            for (int i = 0; i < j1; ++i) {
                d[i] = p.nextRandomNumber();
            }
            Vektor m = new Vektor(d);
            st.push(m);
        }
        return 0;
    }
}

