/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.ExpandConstants;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaFFT;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Vektor;
import java.util.Stack;

class LambdaIFFT
extends Lambda {
    LambdaIFFT() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaIFFT.getNarg(st);
        Vektor x = LambdaIFFT.getVektor(st);
        x = (Vektor)new ExpandConstants().f_exakt(x);
        double[] re = ((Vektor)x.realpart()).getDouble();
        double[] im = ((Vektor)x.imagpart()).getDouble();
        int n = re.length;
        double power = Math.log(n) / Math.log(2.0);
        if (power != (double)Math.round(power)) {
            double[] outRe = new double[n];
            double[] outIm = new double[n];
            LambdaFFT.idft(re, im, outRe, outIm);
            re = outRe;
            im = outIm;
        } else {
            LambdaFFT.ifft_1d(re, im, 1);
        }
        Algebraic[] a = new Unexakt[n];
        for (int i = 0; i < n; ++i) {
            a[i] = new Unexakt(re[i], im[i]);
        }
        st.push(new Vektor(a));
        return 0;
    }
}

