/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.ExpandConstants;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Vektor;
import java.util.Stack;
import org.apache.commons.math3.util.FastMath;

class LambdaFFT
extends Lambda {
    LambdaFFT() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaFFT.getNarg(st);
        Vektor x = LambdaFFT.getVektor(st);
        x = (Vektor)new ExpandConstants().f_exakt(x);
        double[] re = ((Vektor)x.realpart()).getDouble();
        double[] im = ((Vektor)x.imagpart()).getDouble();
        int n = re.length;
        double power = FastMath.log((double)n) / FastMath.log((double)2.0);
        if (power != (double)FastMath.round((double)power)) {
            double[] outRe = new double[n];
            double[] outIm = new double[n];
            LambdaFFT.dft(re, im, outRe, outIm);
            re = outRe;
            im = outIm;
        } else {
            LambdaFFT.ifft_1d(re, im, -1);
        }
        Algebraic[] a = new Unexakt[n];
        for (int i = 0; i < n; ++i) {
            a[i] = new Unexakt(re[i], im[i]);
        }
        st.push(new Vektor(a));
        return 0;
    }

    static void dft(double[] re, double[] im, double[] outRe, double[] outIm) {
        int N = re.length;
        for (int k = 0; k < N; ++k) {
            outIm[k] = 0.0;
            outRe[k] = 0.0;
            for (int n = 0; n < N; ++n) {
                double ang = Math.PI * -2 * (double)k * (double)n / (double)N;
                double eim = FastMath.sin((double)ang);
                double ere = FastMath.cos((double)ang);
                int n2 = k;
                outRe[n2] = outRe[n2] + (re[n] * ere - im[n] * eim);
                int n3 = k;
                outIm[n3] = outIm[n3] + (re[n] * eim + im[n] * ere);
            }
        }
    }

    static void idft(double[] re, double[] im, double[] outRe, double[] outIm) {
        int N = re.length;
        int k = 0;
        while (k < N) {
            outIm[k] = 0.0;
            outRe[k] = 0.0;
            for (int n = 0; n < N; ++n) {
                double ang = Math.PI * 2 * (double)k * (double)n / (double)N;
                double eim = FastMath.sin((double)ang);
                double ere = FastMath.cos((double)ang);
                int n2 = k;
                outRe[n2] = outRe[n2] + (re[n] * ere - im[n] * eim);
                int n3 = k;
                outIm[n3] = outIm[n3] + (re[n] * eim + im[n] * ere);
            }
            int n = k;
            outRe[n] = outRe[n] / (double)N;
            int n4 = k++;
            outIm[n4] = outIm[n4] / (double)N;
        }
    }

    static void ifft_1d(double[] re, double[] im, int sign) {
        double t_i;
        double t_r;
        int i;
        int n = re.length;
        int ln = (int)(FastMath.log((double)n) / FastMath.log((double)2.0) + 0.5);
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = re[i - 1];
                t_i = im[i - 1];
                re[i - 1] = re[j - 1];
                im[i - 1] = im[j - 1];
                re[j - 1] = t_r;
                im[j - 1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(FastMath.exp((double)((double)l * FastMath.log((double)2.0))) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = FastMath.cos((double)(Math.PI / (double)le1));
            double w_i = (double)sign * FastMath.sin((double)(Math.PI / (double)le1));
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= n; i += le) {
                    int ip = i + le1;
                    t_r = re[ip - 1] * u_r - u_i * im[ip - 1];
                    t_i = im[ip - 1] * u_r + u_i * re[ip - 1];
                    re[ip - 1] = re[i - 1] - t_r;
                    im[ip - 1] = im[i - 1] - t_i;
                    re[i - 1] = re[i - 1] + t_r;
                    im[i - 1] = im[i - 1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
        if (sign > 0) {
            i = 0;
            while (i < n) {
                int n2 = i;
                re[n2] = re[n2] / (double)n;
                int n3 = i++;
                im[n3] = im[n3] / (double)n;
            }
        }
    }
}

