/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Variable;
import jasymca.Vektor;
import java.util.Stack;

class LambdaCOEFF
extends Lambda {
    LambdaCOEFF() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaCOEFF.getNarg(st);
        if (narg != 3) {
            throw new ParseException("Usage: COEFF (a, b, c), find coeff of b^c in a");
        }
        Polynomial a = LambdaCOEFF.getPolynomial(st);
        Variable b = LambdaCOEFF.getVariable(st);
        Algebraic c_in = LambdaCOEFF.getAlgebraic(st);
        if (c_in.scalarq()) {
            st.push(a.coefficient(b, LambdaCOEFF.getInteger(c_in)));
        } else if (c_in instanceof Vektor) {
            Vektor c = (Vektor)c_in;
            Algebraic[] v = new Algebraic[c.length()];
            for (int i = 0; i < v.length; ++i) {
                v[i] = a.coefficient(b, LambdaCOEFF.getInteger(c.get(i)));
            }
            st.push(new Vektor(v));
        } else {
            throw new ParseException("Usage: COEFF (a, b, c), find coeff of b^c in a");
        }
        return 0;
    }
}

