/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.swing.models;

import junit.framework.TestCase;
import org.apache.lucene.swing.models.BaseListModel;
import org.apache.lucene.swing.models.DataStore;
import org.apache.lucene.swing.models.ListSearcher;
import org.apache.lucene.swing.models.RestaurantInfo;

public class TestUpdatingList
extends TestCase {
    private BaseListModel baseListModel;
    private ListSearcher listSearcher;
    RestaurantInfo infoToAdd1;
    RestaurantInfo infoToAdd2;

    protected void setUp() throws Exception {
        this.baseListModel = new BaseListModel(DataStore.getRestaurants());
        this.listSearcher = new ListSearcher(this.baseListModel);
        this.infoToAdd1 = new RestaurantInfo();
        this.infoToAdd1.setName("Pino's");
        this.infoToAdd2 = new RestaurantInfo();
        this.infoToAdd2.setName("Pino's");
        this.infoToAdd2.setType("Italian");
    }

    public void testAddWithoutSearch() {
        TestUpdatingList.assertEquals((int)this.baseListModel.getSize(), (int)this.listSearcher.getSize());
        int count = this.listSearcher.getSize();
        this.baseListModel.addRow(this.infoToAdd1);
        TestUpdatingList.assertEquals((int)(++count), (int)this.listSearcher.getSize());
    }

    public void testRemoveWithoutSearch() {
        TestUpdatingList.assertEquals((int)this.baseListModel.getSize(), (int)this.listSearcher.getSize());
        this.baseListModel.addRow(this.infoToAdd1);
        int count = this.listSearcher.getSize();
        this.baseListModel.removeRow(this.infoToAdd1);
        TestUpdatingList.assertEquals((int)(--count), (int)this.listSearcher.getSize());
    }

    public void testAddWithSearch() {
        TestUpdatingList.assertEquals((int)this.baseListModel.getSize(), (int)this.listSearcher.getSize());
        this.listSearcher.search("pino's");
        int count = this.listSearcher.getSize();
        this.baseListModel.addRow(this.infoToAdd2);
        TestUpdatingList.assertEquals((int)(++count), (int)this.listSearcher.getSize());
    }

    public void testRemoveWithSearch() {
        TestUpdatingList.assertEquals((int)this.baseListModel.getSize(), (int)this.listSearcher.getSize());
        this.baseListModel.addRow(this.infoToAdd1);
        this.listSearcher.search("pino's");
        int count = this.listSearcher.getSize();
        this.baseListModel.removeRow(this.infoToAdd1);
        TestUpdatingList.assertEquals((int)(--count), (int)this.listSearcher.getSize());
    }
}

