/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;

public class TokenSources {
    public static TokenStream getAnyTokenStream(IndexReader reader, int docId, String field, Analyzer analyzer) throws IOException {
        TokenStream ts = null;
        TermFreqVector tfv = reader.getTermFreqVector(docId, field);
        if (tfv != null && tfv instanceof TermPositionVector) {
            ts = TokenSources.getTokenStream((TermPositionVector)tfv);
        }
        if (ts == null) {
            ts = TokenSources.getTokenStream(reader, docId, field, analyzer);
        }
        return ts;
    }

    public static TokenStream getTokenStream(TermPositionVector tpv) {
        return TokenSources.getTokenStream(tpv, false);
    }

    public static TokenStream getTokenStream(TermPositionVector tpv, boolean tokenPositionsGuaranteedContiguous) {
        String[] terms = tpv.getTerms();
        int[] freq = tpv.getTermFrequencies();
        int totalTokens = 0;
        for (int t = 0; t < freq.length; ++t) {
            totalTokens += freq[t];
        }
        Token[] tokensInOriginalOrder = new Token[totalTokens];
        ArrayList<Token> unsortedTokens = null;
        for (int t = 0; t < freq.length; ++t) {
            int tp;
            TermVectorOffsetInfo[] offsets = tpv.getOffsets(t);
            if (offsets == null) {
                return null;
            }
            int[] pos = null;
            if (tokenPositionsGuaranteedContiguous) {
                pos = tpv.getTermPositions(t);
            }
            if (pos == null) {
                if (unsortedTokens == null) {
                    unsortedTokens = new ArrayList<Token>();
                }
                for (tp = 0; tp < offsets.length; ++tp) {
                    unsortedTokens.add(new Token(terms[t], offsets[tp].getStartOffset(), offsets[tp].getEndOffset()));
                }
                continue;
            }
            for (tp = 0; tp < pos.length; ++tp) {
                tokensInOriginalOrder[pos[tp]] = new Token(terms[t], offsets[tp].getStartOffset(), offsets[tp].getEndOffset());
            }
        }
        if (unsortedTokens != null) {
            tokensInOriginalOrder = unsortedTokens.toArray(new Token[unsortedTokens.size()]);
            Arrays.sort(tokensInOriginalOrder, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Token t1 = (Token)o1;
                    Token t2 = (Token)o2;
                    if (t1.startOffset() > t2.startOffset()) {
                        return 1;
                    }
                    if (t1.startOffset() < t2.startOffset()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        class StoredTokenStream
        extends TokenStream {
            Token[] tokens;
            int currentToken = 0;

            StoredTokenStream(Token[] tokens) {
                this.tokens = tokens;
            }

            @Override
            public Token next() {
                if (this.currentToken >= this.tokens.length) {
                    return null;
                }
                return this.tokens[this.currentToken++];
            }
        }
        return new StoredTokenStream(tokensInOriginalOrder);
    }

    public static TokenStream getTokenStream(IndexReader reader, int docId, String field) throws IOException {
        TermFreqVector tfv = reader.getTermFreqVector(docId, field);
        if (tfv == null) {
            throw new IllegalArgumentException(field + " in doc #" + docId + "does not have any term position data stored");
        }
        if (tfv instanceof TermPositionVector) {
            TermPositionVector tpv = (TermPositionVector)reader.getTermFreqVector(docId, field);
            return TokenSources.getTokenStream(tpv);
        }
        throw new IllegalArgumentException(field + " in doc #" + docId + "does not have any term position data stored");
    }

    public static TokenStream getTokenStream(IndexReader reader, int docId, String field, Analyzer analyzer) throws IOException {
        Document doc = reader.document(docId);
        String contents = doc.get(field);
        if (contents == null) {
            throw new IllegalArgumentException("Field " + field + " in document #" + docId + " is not stored and cannot be analyzed");
        }
        return analyzer.tokenStream(field, new StringReader(contents));
    }
}

