/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class FloatFieldSource
extends FieldCacheSource {
    private FieldCache.FloatParser parser;

    public FloatFieldSource(String field) {
        this(field, null);
    }

    public FloatFieldSource(String field, FieldCache.FloatParser parser) {
        super(field);
        this.parser = parser;
    }

    @Override
    public String description() {
        return "float(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache cache, String field, IndexReader reader) throws IOException {
        final float[] arr = this.parser == null ? cache.getFloats(reader, field) : cache.getFloats(reader, field, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return arr[doc];
            }

            @Override
            public String toString(int doc) {
                return FloatFieldSource.this.description() + '=' + arr[doc];
            }

            @Override
            Object getInnerArray() {
                return arr;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource o) {
        if (o.getClass() != FloatFieldSource.class) {
            return false;
        }
        FloatFieldSource other = (FloatFieldSource)o;
        return this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Float.class.hashCode() : this.parser.getClass().hashCode();
    }
}

