/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.function.ValueSourceQuery;
import org.apache.lucene.util.ToStringUtils;

public class CustomScoreQuery
extends Query {
    private Query subQuery;
    private ValueSourceQuery[] valSrcQueries;
    private boolean strict;

    public CustomScoreQuery(Query subQuery) {
        this(subQuery, new ValueSourceQuery[0]);
    }

    public CustomScoreQuery(Query subQuery, ValueSourceQuery valSrcQuery) {
        ValueSourceQuery[] valueSourceQueryArray;
        if (valSrcQuery != null) {
            ValueSourceQuery[] valueSourceQueryArray2 = new ValueSourceQuery[1];
            valueSourceQueryArray = valueSourceQueryArray2;
            valueSourceQueryArray2[0] = valSrcQuery;
        } else {
            valueSourceQueryArray = new ValueSourceQuery[]{};
        }
        this(subQuery, valueSourceQueryArray);
    }

    public CustomScoreQuery(Query subQuery, ValueSourceQuery[] valSrcQueries) {
        this.strict = false;
        this.subQuery = subQuery;
        ValueSourceQuery[] valueSourceQueryArray = this.valSrcQueries = valSrcQueries != null ? valSrcQueries : new ValueSourceQuery[]{};
        if (subQuery == null) {
            throw new IllegalArgumentException("<subquery> must not be null!");
        }
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        this.subQuery = this.subQuery.rewrite(reader);
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            this.valSrcQueries[i] = (ValueSourceQuery)this.valSrcQueries[i].rewrite(reader);
        }
        return this;
    }

    @Override
    public void extractTerms(Set terms) {
        this.subQuery.extractTerms(terms);
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            this.valSrcQueries[i].extractTerms(terms);
        }
    }

    @Override
    public Object clone() {
        CustomScoreQuery clone = (CustomScoreQuery)super.clone();
        clone.subQuery = (Query)this.subQuery.clone();
        clone.valSrcQueries = new ValueSourceQuery[this.valSrcQueries.length];
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            clone.valSrcQueries[i] = (ValueSourceQuery)this.valSrcQueries[i].clone();
        }
        return clone;
    }

    @Override
    public String toString(String field) {
        StringBuffer sb = new StringBuffer(this.name()).append("(");
        sb.append(this.subQuery.toString(field));
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            sb.append(", ").append(this.valSrcQueries[i].toString(field));
        }
        sb.append(")");
        sb.append(this.strict ? " STRICT" : "");
        return sb.toString() + ToStringUtils.boost(this.getBoost());
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        CustomScoreQuery other = (CustomScoreQuery)o;
        if (this.getBoost() != other.getBoost() || !this.subQuery.equals(other.subQuery) || this.valSrcQueries.length != other.valSrcQueries.length) {
            return false;
        }
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            if (this.valSrcQueries[i].equals(other.valSrcQueries[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int valSrcHash = 0;
        for (int i = 0; i < this.valSrcQueries.length; ++i) {
            valSrcHash += this.valSrcQueries[i].hashCode();
        }
        return this.getClass().hashCode() + this.subQuery.hashCode() + valSrcHash ^ Float.floatToIntBits(this.getBoost());
    }

    public float customScore(int doc, float subQueryScore, float[] valSrcScores) {
        if (valSrcScores.length == 1) {
            return this.customScore(doc, subQueryScore, valSrcScores[0]);
        }
        if (valSrcScores.length == 0) {
            return this.customScore(doc, subQueryScore, 1.0f);
        }
        float score = subQueryScore;
        for (int i = 0; i < valSrcScores.length; ++i) {
            score *= valSrcScores[i];
        }
        return score;
    }

    public float customScore(int doc, float subQueryScore, float valSrcScore) {
        return subQueryScore * valSrcScore;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation[] valSrcExpls) {
        if (valSrcExpls.length == 1) {
            return this.customExplain(doc, subQueryExpl, valSrcExpls[0]);
        }
        if (valSrcExpls.length == 0) {
            return subQueryExpl;
        }
        float valSrcScore = 1.0f;
        for (int i = 0; i < valSrcExpls.length; ++i) {
            valSrcScore *= valSrcExpls[i].getValue();
        }
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        for (int i = 0; i < valSrcExpls.length; ++i) {
            exp.addDetail(valSrcExpls[i]);
        }
        return exp;
    }

    public Explanation customExplain(int doc, Explanation subQueryExpl, Explanation valSrcExpl) {
        float valSrcScore = 1.0f;
        if (valSrcExpl != null) {
            valSrcScore *= valSrcExpl.getValue();
        }
        Explanation exp = new Explanation(valSrcScore * subQueryExpl.getValue(), "custom score: product of:");
        exp.addDetail(subQueryExpl);
        exp.addDetail(valSrcExpl);
        return exp;
    }

    @Override
    protected Weight createWeight(Searcher searcher) throws IOException {
        return new CustomWeight(searcher);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public String name() {
        return "custom";
    }

    private class CustomScorer
    extends Scorer {
        private final CustomWeight weight;
        private final float qWeight;
        private Scorer subQueryScorer;
        private Scorer[] valSrcScorers;
        private IndexReader reader;
        private float[] vScores;

        private CustomScorer(Similarity similarity, IndexReader reader, CustomWeight w, Scorer subQueryScorer, Scorer[] valSrcScorers) throws IOException {
            super(similarity);
            this.weight = w;
            this.qWeight = w.getValue();
            this.subQueryScorer = subQueryScorer;
            this.valSrcScorers = valSrcScorers;
            this.reader = reader;
            this.vScores = new float[valSrcScorers.length];
        }

        @Override
        public boolean next() throws IOException {
            boolean hasNext = this.subQueryScorer.next();
            if (hasNext) {
                for (int i = 0; i < this.valSrcScorers.length; ++i) {
                    this.valSrcScorers[i].skipTo(this.subQueryScorer.doc());
                }
            }
            return hasNext;
        }

        @Override
        public int doc() {
            return this.subQueryScorer.doc();
        }

        @Override
        public float score() throws IOException {
            for (int i = 0; i < this.valSrcScorers.length; ++i) {
                this.vScores[i] = this.valSrcScorers[i].score();
            }
            return this.qWeight * CustomScoreQuery.this.customScore(this.subQueryScorer.doc(), this.subQueryScorer.score(), this.vScores);
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            boolean hasNext = this.subQueryScorer.skipTo(target);
            if (hasNext) {
                for (int i = 0; i < this.valSrcScorers.length; ++i) {
                    this.valSrcScorers[i].skipTo(this.subQueryScorer.doc());
                }
            }
            return hasNext;
        }

        @Override
        public Explanation explain(int doc) throws IOException {
            Explanation subQueryExpl = this.weight.subQueryWeight.explain(this.reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            Explanation[] valSrcExpls = new Explanation[this.valSrcScorers.length];
            for (int i = 0; i < this.valSrcScorers.length; ++i) {
                valSrcExpls[i] = this.valSrcScorers[i].explain(doc);
            }
            Explanation customExp = CustomScoreQuery.this.customExplain(doc, subQueryExpl, valSrcExpls);
            float sc = this.qWeight * customExp.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, CustomScoreQuery.this.toString() + ", product of:");
            res.addDetail(customExp);
            res.addDetail(new Explanation(this.qWeight, "queryBoost"));
            return res;
        }
    }

    private class CustomWeight
    implements Weight {
        Similarity similarity;
        Weight subQueryWeight;
        Weight[] valSrcWeights;
        boolean qStrict;

        public CustomWeight(Searcher searcher) throws IOException {
            this.similarity = CustomScoreQuery.this.getSimilarity(searcher);
            this.subQueryWeight = CustomScoreQuery.this.subQuery.weight(searcher);
            this.subQueryWeight = CustomScoreQuery.this.subQuery.weight(searcher);
            this.valSrcWeights = new Weight[CustomScoreQuery.this.valSrcQueries.length];
            for (int i = 0; i < CustomScoreQuery.this.valSrcQueries.length; ++i) {
                this.valSrcWeights[i] = CustomScoreQuery.this.valSrcQueries[i].createWeight(searcher);
            }
            this.qStrict = CustomScoreQuery.this.strict;
        }

        @Override
        public Query getQuery() {
            return CustomScoreQuery.this;
        }

        @Override
        public float getValue() {
            return CustomScoreQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum = this.subQueryWeight.sumOfSquaredWeights();
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                if (this.qStrict) {
                    this.valSrcWeights[i].sumOfSquaredWeights();
                    continue;
                }
                sum += this.valSrcWeights[i].sumOfSquaredWeights();
            }
            return sum *= CustomScoreQuery.this.getBoost() * CustomScoreQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= CustomScoreQuery.this.getBoost());
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                if (this.qStrict) {
                    this.valSrcWeights[i].normalize(1.0f);
                    continue;
                }
                this.valSrcWeights[i].normalize(norm);
            }
        }

        @Override
        public Scorer scorer(IndexReader reader) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader);
            Scorer[] valSrcScorers = new Scorer[this.valSrcWeights.length];
            for (int i = 0; i < valSrcScorers.length; ++i) {
                valSrcScorers[i] = this.valSrcWeights[i].scorer(reader);
            }
            return new CustomScorer(this.similarity, reader, this, subQueryScorer, valSrcScorers);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.scorer(reader).explain(doc);
        }
    }
}

