/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

class FieldDocSortedHitQueue
extends PriorityQueue {
    volatile SortField[] fields;
    volatile Collator[] collators;

    FieldDocSortedHitQueue(SortField[] fields, int size) {
        this.fields = fields;
        this.collators = this.hasCollators(fields);
        this.initialize(size);
    }

    synchronized void setFields(SortField[] fields) {
        if (this.fields == null) {
            this.fields = fields;
            this.collators = this.hasCollators(fields);
        }
    }

    SortField[] getFields() {
        return this.fields;
    }

    private Collator[] hasCollators(SortField[] fields) {
        if (fields == null) {
            return null;
        }
        Collator[] ret = new Collator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Locale locale = fields[i].getLocale();
            if (locale == null) continue;
            ret[i] = Collator.getInstance(locale);
        }
        return ret;
    }

    @Override
    protected final boolean lessThan(Object a, Object b) {
        FieldDoc docA = (FieldDoc)a;
        FieldDoc docB = (FieldDoc)b;
        int n = this.fields.length;
        int c = 0;
        for (int i = 0; i < n && c == 0; ++i) {
            int type = this.fields[i].getType();
            switch (type) {
                case 0: {
                    float r1 = ((Float)docA.fields[i]).floatValue();
                    float r2 = ((Float)docB.fields[i]).floatValue();
                    if (r1 > r2) {
                        c = -1;
                    }
                    if (!(r1 < r2)) break;
                    c = 1;
                    break;
                }
                case 1: 
                case 4: {
                    int i1 = (Integer)docA.fields[i];
                    int i2 = (Integer)docB.fields[i];
                    if (i1 < i2) {
                        c = -1;
                    }
                    if (i1 <= i2) break;
                    c = 1;
                    break;
                }
                case 6: {
                    long l1 = (Long)docA.fields[i];
                    long l2 = (Long)docB.fields[i];
                    if (l1 < l2) {
                        c = -1;
                    }
                    if (l1 <= l2) break;
                    c = 1;
                    break;
                }
                case 3: {
                    String s1 = (String)((Object)docA.fields[i]);
                    String s2 = (String)((Object)docB.fields[i]);
                    if (s1 == null) {
                        c = s2 == null ? 0 : -1;
                        break;
                    }
                    if (s2 == null) {
                        c = 1;
                        break;
                    }
                    if (this.fields[i].getLocale() == null) {
                        c = s1.compareTo(s2);
                        break;
                    }
                    c = this.collators[i].compare(s1, s2);
                    break;
                }
                case 5: {
                    float f1 = ((Float)docA.fields[i]).floatValue();
                    float f2 = ((Float)docB.fields[i]).floatValue();
                    if (f1 < f2) {
                        c = -1;
                    }
                    if (!(f1 > f2)) break;
                    c = 1;
                    break;
                }
                case 7: {
                    double d1 = (Double)docA.fields[i];
                    double d2 = (Double)docB.fields[i];
                    if (d1 < d2) {
                        c = -1;
                    }
                    if (!(d1 > d2)) break;
                    c = 1;
                    break;
                }
                case 9: {
                    c = docA.fields[i].compareTo(docB.fields[i]);
                    break;
                }
                case 2: {
                    throw new RuntimeException("FieldDocSortedHitQueue cannot use an AUTO SortField");
                }
                default: {
                    throw new RuntimeException("invalid SortField type: " + type);
                }
            }
            if (!this.fields[i].getReverse()) continue;
            c = -c;
        }
        if (c == 0) {
            return docA.doc > docB.doc;
        }
        return c > 0;
    }
}

