/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;

public class BooleanFilter
extends Filter {
    ArrayList shouldFilters = null;
    ArrayList notFilters = null;
    ArrayList mustFilters = null;

    @Override
    public BitSet bits(IndexReader reader) throws IOException {
        int i;
        BitSet returnBits = null;
        if (this.shouldFilters != null) {
            returnBits = ((Filter)this.shouldFilters.get(0)).bits(reader);
            returnBits = (BitSet)returnBits.clone();
            if (this.shouldFilters.size() > 1) {
                for (i = 1; i < this.shouldFilters.size(); ++i) {
                    returnBits.or(((Filter)this.shouldFilters.get(i)).bits(reader));
                }
            }
        }
        if (this.notFilters != null) {
            for (i = 0; i < this.notFilters.size(); ++i) {
                BitSet notBits = ((Filter)this.notFilters.get(i)).bits(reader);
                if (returnBits == null) {
                    returnBits = (BitSet)notBits.clone();
                    returnBits.flip(0, reader.maxDoc());
                    continue;
                }
                returnBits.andNot(notBits);
            }
        }
        if (this.mustFilters != null) {
            for (i = 0; i < this.mustFilters.size(); ++i) {
                BitSet mustBits = ((Filter)this.mustFilters.get(i)).bits(reader);
                if (returnBits == null) {
                    if (this.mustFilters.size() == 1) {
                        returnBits = mustBits;
                        continue;
                    }
                    returnBits = (BitSet)mustBits.clone();
                    continue;
                }
                returnBits.and(mustBits);
            }
        }
        if (returnBits == null) {
            returnBits = new BitSet(reader.maxDoc());
        }
        return returnBits;
    }

    public void add(FilterClause filterClause) {
        if (filterClause.getOccur().equals(BooleanClause.Occur.MUST)) {
            if (this.mustFilters == null) {
                this.mustFilters = new ArrayList();
            }
            this.mustFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals(BooleanClause.Occur.SHOULD)) {
            if (this.shouldFilters == null) {
                this.shouldFilters = new ArrayList();
            }
            this.shouldFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals(BooleanClause.Occur.MUST_NOT)) {
            if (this.notFilters == null) {
                this.notFilters = new ArrayList();
            }
            this.notFilters.add(filterClause.getFilter());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BooleanFilter test = (BooleanFilter)obj;
        return (this.notFilters == test.notFilters || this.notFilters != null && this.notFilters.equals(test.notFilters)) && (this.mustFilters == test.mustFilters || this.mustFilters != null && this.mustFilters.equals(test.mustFilters)) && (this.shouldFilters == test.shouldFilters || this.shouldFilters != null && this.shouldFilters.equals(test.shouldFilters));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.mustFilters ? 0 : this.mustFilters.hashCode());
        hash = 31 * hash + (null == this.notFilters ? 0 : this.notFilters.hashCode());
        hash = 31 * hash + (null == this.shouldFilters ? 0 : this.shouldFilters.hashCode());
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BooleanFilter(");
        this.appendFilters(this.shouldFilters, null, buffer);
        this.appendFilters(this.mustFilters, "+", buffer);
        this.appendFilters(this.notFilters, "-", buffer);
        buffer.append(")");
        return buffer.toString();
    }

    private void appendFilters(ArrayList filters, String occurString, StringBuffer buffer) {
        if (filters == null) {
            return;
        }
        for (int i = 0; i < filters.size(); ++i) {
            Filter filter = (Filter)filters.get(i);
            if (occurString != null) {
                buffer.append(occurString);
            }
            buffer.append(filter);
            if (i >= filters.size() - 1) continue;
            buffer.append(' ');
        }
    }
}

