/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.misc.ChainedFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryFilter;
import org.apache.lucene.search.RangeFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class ChainedFilterTest
extends TestCase {
    public static final int MAX = 500;
    private RAMDirectory directory;
    private IndexSearcher searcher;
    private Query query;
    private RangeFilter dateFilter;
    private QueryFilter bobFilter;
    private QueryFilter sueFilter;

    public void setUp() throws Exception {
        this.directory = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)this.directory, (Analyzer)new WhitespaceAnalyzer(), true);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(1041397200000L);
        for (int i = 0; i < 500; ++i) {
            Document doc = new Document();
            doc.add(new Field("key", "" + (i + 1), Field.Store.YES, Field.Index.UN_TOKENIZED));
            doc.add(new Field("owner", i < 250 ? "bob" : "sue", Field.Store.YES, Field.Index.UN_TOKENIZED));
            doc.add(new Field("date", cal.getTime().toString(), Field.Store.YES, Field.Index.UN_TOKENIZED));
            writer.addDocument(doc);
            cal.add(5, 1);
        }
        writer.close();
        this.searcher = new IndexSearcher(this.directory);
        BooleanQuery bq = new BooleanQuery();
        bq.add(new TermQuery(new Term("owner", "bob")), BooleanClause.Occur.SHOULD);
        bq.add(new TermQuery(new Term("owner", "sue")), BooleanClause.Occur.SHOULD);
        this.query = bq;
        Date pastTheEnd = this.parseDate("2099 Jan 1");
        this.dateFilter = new RangeFilter("date", "", "ZZZZ", true, true);
        this.bobFilter = new QueryFilter(new TermQuery(new Term("owner", "bob")));
        this.sueFilter = new QueryFilter(new TermQuery(new Term("owner", "sue")));
    }

    public void testSingleFilter() throws Exception {
        ChainedFilter chain = new ChainedFilter(new Filter[]{this.dateFilter});
        Hits hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((int)500, (int)hits.length());
        chain = new ChainedFilter(new Filter[]{this.bobFilter});
        hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((int)250, (int)hits.length());
        chain = new ChainedFilter(new Filter[]{this.bobFilter}, new int[]{1});
        hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((int)250, (int)hits.length());
        ChainedFilterTest.assertEquals((String)"bob", (String)hits.doc(0).get("owner"));
        chain = new ChainedFilter(new Filter[]{this.bobFilter}, new int[]{2});
        hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((int)250, (int)hits.length());
        ChainedFilterTest.assertEquals((String)"sue", (String)hits.doc(0).get("owner"));
    }

    public void testOR() throws Exception {
        ChainedFilter chain = new ChainedFilter(new Filter[]{this.sueFilter, this.bobFilter});
        Hits hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((String)"OR matches all", (int)500, (int)hits.length());
    }

    public void testAND() throws Exception {
        ChainedFilter chain = new ChainedFilter(new Filter[]{this.dateFilter, this.bobFilter}, 1);
        Hits hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((String)"AND matches just bob", (int)250, (int)hits.length());
        ChainedFilterTest.assertEquals((String)"bob", (String)hits.doc(0).get("owner"));
    }

    public void testXOR() throws Exception {
        ChainedFilter chain = new ChainedFilter(new Filter[]{this.dateFilter, this.bobFilter}, 3);
        Hits hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((String)"XOR matches sue", (int)250, (int)hits.length());
        ChainedFilterTest.assertEquals((String)"sue", (String)hits.doc(0).get("owner"));
    }

    public void testANDNOT() throws Exception {
        ChainedFilter chain = new ChainedFilter(new Filter[]{this.dateFilter, this.sueFilter}, new int[]{1, 2});
        Hits hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((String)"ANDNOT matches just bob", (int)250, (int)hits.length());
        ChainedFilterTest.assertEquals((String)"bob", (String)hits.doc(0).get("owner"));
        chain = new ChainedFilter(new Filter[]{this.bobFilter, this.bobFilter}, new int[]{2, 2});
        hits = this.searcher.search(this.query, chain);
        ChainedFilterTest.assertEquals((String)"ANDNOT bob ANDNOT bob matches all sues", (int)250, (int)hits.length());
        ChainedFilterTest.assertEquals((String)"sue", (String)hits.doc(0).get("owner"));
    }

    private Date parseDate(String s) throws ParseException {
        return new SimpleDateFormat("yyyy MMM dd", Locale.US).parse(s);
    }
}

