/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;

final class TermVectorsWriter {
    private IndexOutput tvx = null;
    private IndexOutput tvd = null;
    private IndexOutput tvf = null;
    private FieldInfos fieldInfos;

    public TermVectorsWriter(Directory directory, String segment, FieldInfos fieldInfos) throws IOException {
        this.tvx = directory.createOutput(segment + "." + "tvx");
        this.tvx.writeInt(2);
        this.tvd = directory.createOutput(segment + "." + "tvd");
        this.tvd.writeInt(2);
        this.tvf = directory.createOutput(segment + "." + "tvf");
        this.tvf.writeInt(2);
        this.fieldInfos = fieldInfos;
    }

    public final void addAllDocVectors(TermFreqVector[] vectors) throws IOException {
        this.tvx.writeLong(this.tvd.getFilePointer());
        if (vectors != null) {
            int numFields = vectors.length;
            this.tvd.writeVInt(numFields);
            long[] fieldPointers = new long[numFields];
            for (int i = 0; i < numFields; ++i) {
                int bits;
                boolean storeOffsets;
                boolean storePositions;
                TermPositionVector tpVector;
                fieldPointers[i] = this.tvf.getFilePointer();
                int fieldNumber = this.fieldInfos.fieldNumber(vectors[i].getField());
                this.tvd.writeVInt(fieldNumber);
                int numTerms = vectors[i].size();
                this.tvf.writeVInt(numTerms);
                if (vectors[i] instanceof TermPositionVector) {
                    tpVector = (TermPositionVector)vectors[i];
                    storePositions = tpVector.size() > 0 && tpVector.getTermPositions(0) != null;
                    storeOffsets = tpVector.size() > 0 && tpVector.getOffsets(0) != null;
                    bits = (byte)((storePositions ? 1 : 0) + (storeOffsets ? 2 : 0));
                } else {
                    tpVector = null;
                    bits = 0;
                    storePositions = false;
                    storeOffsets = false;
                }
                this.tvf.writeVInt(bits);
                String[] terms = vectors[i].getTerms();
                int[] freqs = vectors[i].getTermFrequencies();
                String lastTermText = "";
                for (int j = 0; j < numTerms; ++j) {
                    int k;
                    String termText = terms[j];
                    int start = StringHelper.stringDifference(lastTermText, termText);
                    int length = termText.length() - start;
                    this.tvf.writeVInt(start);
                    this.tvf.writeVInt(length);
                    this.tvf.writeChars(termText, start, length);
                    lastTermText = termText;
                    int termFreq = freqs[j];
                    this.tvf.writeVInt(termFreq);
                    if (storePositions) {
                        int[] positions = tpVector.getTermPositions(j);
                        if (positions == null) {
                            throw new IllegalStateException("Trying to write positions that are null!");
                        }
                        assert (positions.length == termFreq);
                        int lastPosition = 0;
                        for (k = 0; k < positions.length; ++k) {
                            int position = positions[k];
                            this.tvf.writeVInt(position - lastPosition);
                            lastPosition = position;
                        }
                    }
                    if (!storeOffsets) continue;
                    TermVectorOffsetInfo[] offsets = tpVector.getOffsets(j);
                    if (offsets == null) {
                        throw new IllegalStateException("Trying to write offsets that are null!");
                    }
                    assert (offsets.length == termFreq);
                    int lastEndOffset = 0;
                    for (k = 0; k < offsets.length; ++k) {
                        int startOffset = offsets[k].getStartOffset();
                        int endOffset = offsets[k].getEndOffset();
                        this.tvf.writeVInt(startOffset - lastEndOffset);
                        this.tvf.writeVInt(endOffset - startOffset);
                        lastEndOffset = endOffset;
                    }
                }
            }
            long lastFieldPointer = 0L;
            for (int i = 0; i < numFields; ++i) {
                long fieldPointer = fieldPointers[i];
                this.tvd.writeVLong(fieldPointer - lastFieldPointer);
                lastFieldPointer = fieldPointer;
            }
        } else {
            this.tvd.writeVInt(0);
        }
    }

    final void close() throws IOException {
        IOException keep;
        block12: {
            block11: {
                block10: {
                    keep = null;
                    if (this.tvx != null) {
                        try {
                            this.tvx.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block10;
                            keep = e;
                        }
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block11;
                        keep = e;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException e) {
                    if (keep != null) break block12;
                    keep = e;
                }
            }
        }
        if (keep != null) {
            throw (IOException)keep.fillInStackTrace();
        }
    }
}

