/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;

class MultiSegmentReader
extends DirectoryIndexReader {
    protected SegmentReader[] subReaders;
    private int[] starts;
    private Hashtable normsCache = new Hashtable();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;

    MultiSegmentReader(Directory directory, SegmentInfos sis, boolean closeDirectory) throws IOException {
        super(directory, sis, closeDirectory);
        SegmentReader[] readers = new SegmentReader[sis.size()];
        for (int i = sis.size() - 1; i >= 0; --i) {
            try {
                readers[i] = SegmentReader.get(sis.info(i));
                continue;
            }
            catch (IOException e) {
                ++i;
                while (i < sis.size()) {
                    try {
                        readers[i].close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ++i;
                }
                throw e;
            }
        }
        this.initialize(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiSegmentReader(Directory directory, SegmentInfos infos, boolean closeDirectory, SegmentReader[] oldReaders, int[] oldStarts, Map oldNormsCache) throws IOException {
        super(directory, infos, closeDirectory);
        HashMap<String, Integer> segmentReaders = new HashMap<String, Integer>();
        if (oldReaders != null) {
            for (int i = 0; i < oldReaders.length; ++i) {
                segmentReaders.put(oldReaders[i].getSegmentName(), new Integer(i));
            }
        }
        SegmentReader[] newReaders = new SegmentReader[infos.size()];
        boolean[] readerShared = new boolean[infos.size()];
        for (int i = infos.size() - 1; i >= 0; --i) {
            Integer oldReaderIndex = (Integer)segmentReaders.get(infos.info((int)i).name);
            newReaders[i] = oldReaderIndex == null ? null : oldReaders[oldReaderIndex];
            boolean success = false;
            try {
                SegmentReader newReader = newReaders[i] == null || infos.info(i).getUseCompoundFile() != newReaders[i].getSegmentInfo().getUseCompoundFile() ? SegmentReader.get(infos.info(i)) : newReaders[i].reopenSegment(infos.info(i));
                if (newReader == newReaders[i]) {
                    readerShared[i] = true;
                    newReader.incRef();
                } else {
                    readerShared[i] = false;
                    newReaders[i] = newReader;
                }
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    ++i;
                    while (i < infos.size()) {
                        if (newReaders[i] != null) {
                            try {
                                if (!readerShared[i]) {
                                    newReaders[i].close();
                                } else {
                                    newReaders[i].decRef();
                                }
                            }
                            catch (IOException newReader) {}
                        }
                        ++i;
                    }
                }
            }
        }
        this.initialize(newReaders);
        if (oldNormsCache != null) {
            for (String field : oldNormsCache.keySet()) {
                if (!this.hasNorms(field)) continue;
                byte[] oldBytes = (byte[])oldNormsCache.get(field);
                byte[] bytes = new byte[this.maxDoc()];
                for (int i = 0; i < this.subReaders.length; ++i) {
                    Integer oldReaderIndex = (Integer)segmentReaders.get(this.subReaders[i].getSegmentName());
                    if (oldReaderIndex != null && (oldReaders[oldReaderIndex] == this.subReaders[i] || oldReaders[oldReaderIndex.intValue()].norms.get(field) == this.subReaders[i].norms.get(field))) {
                        System.arraycopy(oldBytes, oldStarts[oldReaderIndex], bytes, this.starts[i], this.starts[i + 1] - this.starts[i]);
                        continue;
                    }
                    this.subReaders[i].norms(field, bytes, this.starts[i]);
                }
                this.normsCache.put(field, bytes);
            }
        }
    }

    private void initialize(SegmentReader[] subReaders) {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    @Override
    protected synchronized DirectoryIndexReader doReopen(SegmentInfos infos) throws CorruptIndexException, IOException {
        if (infos.size() == 1) {
            SegmentReader newReader = SegmentReader.get(infos, infos.info(0), false);
            return newReader;
        }
        return new MultiSegmentReader(this.directory, infos, this.closeDirectory, this.subReaders, this.starts, this.normsCache);
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field);
    }

    @Override
    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], field, mapper);
    }

    @Override
    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], mapper);
    }

    @Override
    public boolean isOptimized() {
        return false;
    }

    @Override
    public synchronized int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    @Override
    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return MultiSegmentReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    static int readerIndex(int n, int[] starts, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    @Override
    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    @Override
    public synchronized byte[] norms(String field) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field)) {
            return this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, bytes, this.starts[i]);
        }
        this.normsCache.put(field, bytes);
        return bytes;
    }

    @Override
    public synchronized void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field);
        if (bytes == null && !this.hasNorms(field)) {
            bytes = this.fakeNorms();
        }
        if (bytes != null) {
            System.arraycopy(bytes, 0, result, offset, this.maxDoc());
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field, result, offset + this.starts[i]);
        }
    }

    @Override
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        this.normsCache.remove(field);
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field, value);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new MultiTermDocs(this.subReaders, this.starts);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new MultiTermPositions(this.subReaders, this.starts);
    }

    @Override
    protected void commitChanges() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit();
        }
    }

    @Override
    void startCommit() {
        super.startCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].startCommit();
        }
    }

    @Override
    void rollbackCommit() {
        super.rollbackCommit();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].rollbackCommit();
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].decRef();
        }
        super.doClose();
    }

    @Override
    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return MultiSegmentReader.getFieldNames(fieldNames, this.subReaders);
    }

    static Collection getFieldNames(IndexReader.FieldOption fieldNames, IndexReader[] subReaders) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < subReaders.length; ++i) {
            IndexReader reader = subReaders[i];
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    SegmentReader[] getSubReaders() {
        return this.subReaders;
    }

    @Override
    public void setTermInfosIndexDivisor(int indexDivisor) throws IllegalStateException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].setTermInfosIndexDivisor(indexDivisor);
        }
    }

    @Override
    public int getTermInfosIndexDivisor() throws IllegalStateException {
        if (this.subReaders.length > 0) {
            return this.subReaders[0].getTermInfosIndexDivisor();
        }
        throw new IllegalStateException("no readers");
    }

    static class MultiTermPositions
    extends MultiTermDocs
    implements TermPositions {
        public MultiTermPositions(IndexReader[] r, int[] s) {
            super(r, s);
        }

        @Override
        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return reader.termPositions();
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.current).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.current).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.current).getPayload(data, offset);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.current).isPayloadAvailable();
        }
    }

    static class MultiTermDocs
    implements TermDocs {
        protected IndexReader[] readers;
        protected int[] starts;
        protected Term term;
        protected int base = 0;
        protected int pointer = 0;
        private TermDocs[] readerTermDocs;
        protected TermDocs current;

        public MultiTermDocs(IndexReader[] r, int[] s) {
            this.readers = r;
            this.starts = s;
            this.readerTermDocs = new TermDocs[r.length];
        }

        @Override
        public int doc() {
            return this.base + this.current.doc();
        }

        @Override
        public int freq() {
            return this.current.freq();
        }

        @Override
        public void seek(Term term) {
            this.term = term;
            this.base = 0;
            this.pointer = 0;
            this.current = null;
        }

        @Override
        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        @Override
        public boolean next() throws IOException {
            while (true) {
                if (this.current != null && this.current.next()) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        @Override
        public int read(int[] docs, int[] freqs) throws IOException {
            int end;
            while (true) {
                if (this.current == null) {
                    if (this.pointer < this.readers.length) {
                        this.base = this.starts[this.pointer];
                        this.current = this.termDocs(this.pointer++);
                        continue;
                    }
                    return 0;
                }
                end = this.current.read(docs, freqs);
                if (end != 0) break;
                this.current = null;
            }
            int b = this.base;
            int i = 0;
            while (i < end) {
                int n = i++;
                docs[n] = docs[n] + b;
            }
            return end;
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            while (true) {
                if (this.current != null && this.current.skipTo(target - this.base)) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        private TermDocs termDocs(int i) throws IOException {
            if (this.term == null) {
                return null;
            }
            TermDocs result = this.readerTermDocs[i];
            if (result == null) {
                result = this.readerTermDocs[i] = this.termDocs(this.readers[i]);
            }
            result.seek(this.term);
            return result;
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return reader.termDocs();
        }

        @Override
        public void close() throws IOException {
            for (int i = 0; i < this.readerTermDocs.length; ++i) {
                if (this.readerTermDocs[i] == null) continue;
                this.readerTermDocs[i].close();
            }
        }
    }

    static class MultiTermEnum
    extends TermEnum {
        private SegmentMergeQueue queue;
        private Term term;
        private int docFreq;

        public MultiTermEnum(IndexReader[] readers, int[] starts, Term t) throws IOException {
            this.queue = new SegmentMergeQueue(readers.length);
            for (int i = 0; i < readers.length; ++i) {
                IndexReader reader = readers[i];
                TermEnum termEnum = t != null ? reader.terms(t) : reader.terms();
                SegmentMergeInfo smi = new SegmentMergeInfo(starts[i], termEnum, reader);
                if (t == null ? smi.next() : termEnum.term() != null) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
            if (t != null && this.queue.size() > 0) {
                this.next();
            }
        }

        @Override
        public boolean next() throws IOException {
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            if (top == null) {
                this.term = null;
                return false;
            }
            this.term = top.term;
            this.docFreq = 0;
            while (top != null && this.term.compareTo(top.term) == 0) {
                this.queue.pop();
                this.docFreq += top.termEnum.docFreq();
                if (top.next()) {
                    this.queue.put(top);
                } else {
                    top.close();
                }
                top = (SegmentMergeInfo)this.queue.top();
            }
            return true;
        }

        @Override
        public Term term() {
            return this.term;
        }

        @Override
        public int docFreq() {
            return this.docFreq;
        }

        @Override
        public void close() throws IOException {
            this.queue.close();
        }
    }
}

