/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

class CompoundFileReader
extends Directory {
    private int readBufferSize;
    private Directory directory;
    private String fileName;
    private IndexInput stream;
    private HashMap entries = new HashMap();

    public CompoundFileReader(Directory dir, String name) throws IOException {
        this(dir, name, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundFileReader(Directory dir, String name, int readBufferSize) throws IOException {
        this.directory = dir;
        this.fileName = name;
        this.readBufferSize = readBufferSize;
        boolean success = false;
        try {
            this.stream = dir.openInput(name, readBufferSize);
            int count = this.stream.readVInt();
            FileEntry entry = null;
            for (int i = 0; i < count; ++i) {
                long offset = this.stream.readLong();
                String id = this.stream.readString();
                if (entry != null) {
                    entry.length = offset - entry.offset;
                }
                entry = new FileEntry();
                entry.offset = offset;
                this.entries.put(id, entry);
            }
            if (entry != null) {
                entry.length = this.stream.length() - entry.offset;
            }
            success = true;
        }
        finally {
            if (!success && this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.stream == null) {
            throw new IOException("Already closed");
        }
        this.entries.clear();
        this.stream.close();
        this.stream = null;
    }

    @Override
    public synchronized IndexInput openInput(String id) throws IOException {
        return this.openInput(id, this.readBufferSize);
    }

    @Override
    public synchronized IndexInput openInput(String id, int readBufferSize) throws IOException {
        if (this.stream == null) {
            throw new IOException("Stream closed");
        }
        FileEntry entry = (FileEntry)this.entries.get(id);
        if (entry == null) {
            throw new IOException("No sub-file with id " + id + " found");
        }
        return new CSIndexInput(this.stream, entry.offset, entry.length, readBufferSize);
    }

    @Override
    public String[] list() {
        String[] res = new String[this.entries.size()];
        return this.entries.keySet().toArray(res);
    }

    @Override
    public boolean fileExists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public long fileModified(String name) throws IOException {
        return this.directory.fileModified(this.fileName);
    }

    @Override
    public void touchFile(String name) throws IOException {
        this.directory.touchFile(this.fileName);
    }

    @Override
    public void deleteFile(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void renameFile(String from, String to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long fileLength(String name) throws IOException {
        FileEntry e = (FileEntry)this.entries.get(name);
        if (e == null) {
            throw new IOException("File " + name + " does not exist");
        }
        return e.length;
    }

    @Override
    public IndexOutput createOutput(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lock makeLock(String name) {
        throw new UnsupportedOperationException();
    }

    static final class CSIndexInput
    extends BufferedIndexInput {
        IndexInput base;
        long fileOffset;
        long length;

        CSIndexInput(IndexInput base, long fileOffset, long length) {
            this(base, fileOffset, length, 1024);
        }

        CSIndexInput(IndexInput base, long fileOffset, long length, int readBufferSize) {
            super(readBufferSize);
            this.base = base;
            this.fileOffset = fileOffset;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            IndexInput indexInput = this.base;
            synchronized (indexInput) {
                long start = this.getFilePointer();
                if (start + (long)len > this.length) {
                    throw new IOException("read past EOF");
                }
                this.base.seek(this.fileOffset + start);
                this.base.readBytes(b, offset, len, false);
            }
        }

        @Override
        protected void seekInternal(long pos) {
        }

        @Override
        public void close() {
        }

        @Override
        public long length() {
            return this.length;
        }
    }

    private static final class FileEntry {
        long offset;
        long length;

        private FileEntry() {
        }
    }
}

