/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sinks;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.TeeTokenFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.sinks.TokenTypeSinkTokenizer;

public class TokenTypeSinkTokenizerTest
extends TestCase {
    public TokenTypeSinkTokenizerTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void test() throws IOException {
        TokenTypeSinkTokenizer sink = new TokenTypeSinkTokenizer("D");
        String test = "The quick red fox jumped over the lazy brown dogs";
        TeeTokenFilter ttf = new TeeTokenFilter(new WordTokenFilter(new WhitespaceTokenizer(new StringReader(test))), sink);
        Token tok = new Token();
        boolean seenDogs = false;
        while ((tok = ttf.next(tok)) != null) {
            if (tok.termText().equals("dogs")) {
                seenDogs = true;
                TokenTypeSinkTokenizerTest.assertTrue((String)(tok.type() + " is not equal to D"), (tok.type().equals("D") ? 1 : 0) != 0);
                continue;
            }
            TokenTypeSinkTokenizerTest.assertTrue((String)(tok.type() + " is not null and it should be"), (boolean)tok.type().equals("word"));
        }
        TokenTypeSinkTokenizerTest.assertTrue((String)(seenDogs + " does not equal: " + true), (seenDogs ? 1 : 0) != 0);
        TokenTypeSinkTokenizerTest.assertTrue((String)("sink Size: " + sink.getTokens().size() + " is not: " + 1), (sink.getTokens().size() == 1 ? 1 : 0) != 0);
    }

    private class WordTokenFilter
    extends TokenFilter {
        private WordTokenFilter(TokenStream input) {
            super(input);
        }

        @Override
        public Token next(Token result) throws IOException {
            if ((result = this.input.next(result)) != null && result.termText().equals("dogs")) {
                result.setType("D");
            }
            return result;
        }
    }
}

