/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sinks;

import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import junit.framework.TestCase;
import org.apache.lucene.analysis.TeeTokenFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.sinks.DateRecognizerSinkTokenizer;

public class DateRecognizerSinkTokenizerTest
extends TestCase {
    public DateRecognizerSinkTokenizerTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void test() throws IOException {
        DateRecognizerSinkTokenizer sink = new DateRecognizerSinkTokenizer(new SimpleDateFormat("MM/dd/yyyy"));
        String test = "The quick red fox jumped over the lazy brown dogs on 7/11/2006  The dogs finally reacted on 7/12/2006";
        TeeTokenFilter tee = new TeeTokenFilter(new WhitespaceTokenizer(new StringReader(test)), sink);
        Token tok = null;
        int count = 0;
        while ((tok = tee.next()) != null) {
            DateRecognizerSinkTokenizerTest.assertTrue((String)"tok is null and it shouldn't be", (tok != null ? 1 : 0) != 0);
            if (tok.termBuffer()[0] == '7') {
                DateRecognizerSinkTokenizerTest.assertTrue((String)(tok.type() + " is not equal to " + "date"), (tok.type().equals("date") ? 1 : 0) != 0);
            }
            ++count;
        }
        DateRecognizerSinkTokenizerTest.assertTrue((String)(count + " does not equal: " + 18), (count == 18 ? 1 : 0) != 0);
        DateRecognizerSinkTokenizerTest.assertTrue((String)("sink Size: " + sink.getTokens().size() + " is not: " + 2), (sink.getTokens().size() == 2 ? 1 : 0) != 0);
    }
}

