/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.ru.RussianCharsets;
import org.apache.lucene.analysis.ru.RussianLetterTokenizer;

public class TestRussianAnalyzer
extends TestCase {
    private InputStreamReader inWords;
    private InputStreamReader sampleUnicode;
    private Reader inWordsKOI8;
    private Reader sampleKOI8;
    private Reader inWords1251;
    private Reader sample1251;
    private File dataDir;

    protected void setUp() throws Exception {
        this.dataDir = new File(System.getProperty("dataDir", "./bin"));
    }

    public void testUnicode() throws IOException {
        Token token;
        RussianAnalyzer ra = new RussianAnalyzer(RussianCharsets.UnicodeRussian);
        this.inWords = new InputStreamReader((InputStream)new FileInputStream(new File(this.dataDir, "/org/apache/lucene/analysis/ru/testUnicode.txt")), "Unicode");
        this.sampleUnicode = new InputStreamReader((InputStream)new FileInputStream(new File(this.dataDir, "/org/apache/lucene/analysis/ru/resUnicode.htm")), "Unicode");
        TokenStream in = ra.tokenStream("all", this.inWords);
        RussianLetterTokenizer sample = new RussianLetterTokenizer(this.sampleUnicode, RussianCharsets.UnicodeRussian);
        while ((token = in.next()) != null) {
            Token sampleToken = sample.next();
            TestRussianAnalyzer.assertEquals((String)"Unicode", (String)token.termText(), (String)(sampleToken == null ? null : sampleToken.termText()));
        }
        this.inWords.close();
        this.sampleUnicode.close();
    }

    public void testKOI8() throws IOException {
        Token token;
        RussianAnalyzer ra = new RussianAnalyzer(RussianCharsets.KOI8);
        this.inWordsKOI8 = new InputStreamReader((InputStream)new FileInputStream(new File(this.dataDir, "/org/apache/lucene/analysis/ru/testKOI8.txt")), "iso-8859-1");
        this.sampleKOI8 = new InputStreamReader((InputStream)new FileInputStream(new File(this.dataDir, "/org/apache/lucene/analysis/ru/resKOI8.htm")), "iso-8859-1");
        TokenStream in = ra.tokenStream("all", this.inWordsKOI8);
        RussianLetterTokenizer sample = new RussianLetterTokenizer(this.sampleKOI8, RussianCharsets.KOI8);
        while ((token = in.next()) != null) {
            Token sampleToken = sample.next();
            TestRussianAnalyzer.assertEquals((String)"KOI8", (String)token.termText(), (String)(sampleToken == null ? null : sampleToken.termText()));
        }
        this.inWordsKOI8.close();
        this.sampleKOI8.close();
    }

    public void test1251() throws IOException {
        Token token;
        this.inWords1251 = new InputStreamReader((InputStream)new FileInputStream(new File(this.dataDir, "/org/apache/lucene/analysis/ru/test1251.txt")), "iso-8859-1");
        this.sample1251 = new InputStreamReader((InputStream)new FileInputStream(new File(this.dataDir, "/org/apache/lucene/analysis/ru/res1251.htm")), "iso-8859-1");
        RussianAnalyzer ra = new RussianAnalyzer(RussianCharsets.CP1251);
        TokenStream in = ra.tokenStream("", this.inWords1251);
        RussianLetterTokenizer sample = new RussianLetterTokenizer(this.sample1251, RussianCharsets.CP1251);
        while ((token = in.next()) != null) {
            Token sampleToken = sample.next();
            TestRussianAnalyzer.assertEquals((String)"1251", (String)token.termText(), (String)(sampleToken == null ? null : sampleToken.termText()));
        }
        this.inWords1251.close();
        this.sample1251.close();
    }
}

