/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.payloads.NumericPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.PayloadHelper;

public class NumericPayloadTokenFilterTest
extends TestCase {
    public NumericPayloadTokenFilterTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void test() throws IOException {
        String test = "The quick red fox jumped over the lazy brown dogs";
        NumericPayloadTokenFilter nptf = new NumericPayloadTokenFilter(new WordTokenFilter(new WhitespaceTokenizer(new StringReader(test))), 3.0f, "D");
        Token tok = new Token();
        boolean seenDogs = false;
        while ((tok = nptf.next(tok)) != null) {
            if (tok.termText().equals("dogs")) {
                seenDogs = true;
                NumericPayloadTokenFilterTest.assertTrue((String)(tok.type() + " is not equal to D"), (tok.type().equals("D") ? 1 : 0) != 0);
                NumericPayloadTokenFilterTest.assertTrue((String)"tok.getPayload() is null and it shouldn't be", (tok.getPayload() != null ? 1 : 0) != 0);
                byte[] bytes = tok.getPayload().getData();
                NumericPayloadTokenFilterTest.assertTrue((String)(bytes.length + " does not equal: " + tok.getPayload().length()), (bytes.length == tok.getPayload().length() ? 1 : 0) != 0);
                NumericPayloadTokenFilterTest.assertTrue((String)(tok.getPayload().getOffset() + " does not equal: " + 0), (tok.getPayload().getOffset() == 0 ? 1 : 0) != 0);
                float pay = PayloadHelper.decodeFloat(bytes);
                NumericPayloadTokenFilterTest.assertTrue((String)(pay + " does not equal: " + 3), (pay == 3.0f ? 1 : 0) != 0);
                continue;
            }
            NumericPayloadTokenFilterTest.assertTrue((String)(tok.type() + " is not null and it should be"), (boolean)tok.type().equals("word"));
        }
        NumericPayloadTokenFilterTest.assertTrue((String)(seenDogs + " does not equal: " + true), (seenDogs ? 1 : 0) != 0);
    }

    private class WordTokenFilter
    extends TokenFilter {
        private WordTokenFilter(TokenStream input) {
            super(input);
        }

        @Override
        public Token next(Token result) throws IOException {
            if ((result = this.input.next(result)) != null && result.termText().equals("dogs")) {
                result.setType("D");
            }
            return result;
        }
    }
}

