/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;

public class EdgeNGramTokenFilterTest
extends TestCase {
    private TokenStream input;

    public void setUp() {
        this.input = new WhitespaceTokenizer(new StringReader("abcde"));
    }

    public void testInvalidInput() throws Exception {
        boolean gotException = false;
        try {
            new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.FRONT, 0, 0);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        EdgeNGramTokenFilterTest.assertTrue((boolean)gotException);
    }

    public void testInvalidInput2() throws Exception {
        boolean gotException = false;
        try {
            new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.FRONT, 2, 1);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        EdgeNGramTokenFilterTest.assertTrue((boolean)gotException);
    }

    public void testInvalidInput3() throws Exception {
        boolean gotException = false;
        try {
            new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.FRONT, -1, 2);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        EdgeNGramTokenFilterTest.assertTrue((boolean)gotException);
    }

    public void testFrontUnigram() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.FRONT, 1, 1);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(a,0,1)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertNull((Object)token);
    }

    public void testBackUnigram() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.BACK, 1, 1);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(e,4,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertNull((Object)token);
    }

    public void testOversizedNgrams() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.FRONT, 6, 6);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertNull((Object)token);
    }

    public void testFrontRangeOfNgrams() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.FRONT, 1, 3);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(a,0,1)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(ab,0,2)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(abc,0,3)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertNull((Object)token);
    }

    public void testBackRangeOfNgrams() throws Exception {
        EdgeNGramTokenFilter tokenizer = new EdgeNGramTokenFilter(this.input, EdgeNGramTokenFilter.Side.BACK, 1, 3);
        Token token = null;
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(e,4,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(de,3,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertEquals((String)"(cde,2,5)", (String)token.toString());
        token = tokenizer.next();
        EdgeNGramTokenFilterTest.assertNull((Object)token);
    }
}

