/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class EdgeNGramTokenFilter
extends TokenFilter {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private int minGram;
    private int maxGram;
    private Side side;
    private LinkedList ngrams;

    protected EdgeNGramTokenFilter(TokenStream input) {
        super(input);
        this.ngrams = new LinkedList();
    }

    public EdgeNGramTokenFilter(TokenStream input, Side side, int minGram, int maxGram) {
        super(input);
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
        this.ngrams = new LinkedList();
    }

    public EdgeNGramTokenFilter(TokenStream input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    @Override
    public final Token next() throws IOException {
        if (this.ngrams.size() > 0) {
            return (Token)this.ngrams.removeFirst();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.ngram(token);
        if (this.ngrams.size() > 0) {
            return (Token)this.ngrams.removeFirst();
        }
        return null;
    }

    private void ngram(Token token) {
        String inStr = token.termText();
        int inLen = inStr.length();
        for (int gramSize = this.minGram; gramSize <= this.maxGram; ++gramSize) {
            if (gramSize > inLen) {
                return;
            }
            if (gramSize > this.maxGram) {
                return;
            }
            Token tok = this.side == Side.FRONT ? new Token(inStr.substring(0, gramSize), 0, gramSize) : new Token(inStr.substring(inLen - gramSize), inLen - gramSize, inLen);
            this.ngrams.add(tok);
        }
    }

    public static class Side {
        private String label;
        public static Side FRONT = new Side("front");
        public static Side BACK = new Side("back");

        private Side(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

