/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class TestGermanStemFilter
extends TestCase {
    public void testStemming() {
        try {
            String line;
            File dataDir = new File(System.getProperty("dataDir", "./bin"));
            File testFile = new File(dataDir, "org/apache/lucene/analysis/de/data.txt");
            FileInputStream fis = new FileInputStream(testFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "iso-8859-1");
            BufferedReader breader = new BufferedReader(isr);
            while ((line = breader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                String[] parts = line.split(";");
                this.check(parts[0], parts[1]);
            }
            breader.close();
            isr.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            TestGermanStemFilter.fail();
        }
    }

    private void check(String input, String expected) throws IOException {
        StandardTokenizer tokenStream = new StandardTokenizer(new StringReader(input));
        GermanStemFilter filter = new GermanStemFilter(tokenStream);
        Token t = filter.next();
        if (t == null) {
            TestGermanStemFilter.fail();
        }
        TestGermanStemFilter.assertEquals((String)expected, (String)t.termText());
        filter.close();
    }
}

