/*
 * Decompiled with CFR 0.152.
 */
package org.joone.script;

import java.io.Serializable;
import java.util.Hashtable;
import org.joone.script.JooneMacro;

public class MacroManager
implements Serializable {
    static final long serialVersionUID = 2855350620727616763L;
    private Hashtable macros = this.initMacro(this.macros);

    protected Hashtable initMacro(Hashtable mm) {
        JooneMacro macro = new JooneMacro();
        macro.setName("cycleTerminated");
        macro.setText("");
        macro.setEventMacro(true);
        mm.put(macro.getName(), macro);
        macro = new JooneMacro();
        macro.setName("errorChanged");
        macro.setText("");
        macro.setEventMacro(true);
        mm.put(macro.getName(), macro);
        macro = new JooneMacro();
        macro.setName("netStarted");
        macro.setText("");
        macro.setEventMacro(true);
        mm.put(macro.getName(), macro);
        macro = new JooneMacro();
        macro.setName("netStopped");
        macro.setText("");
        macro.setEventMacro(true);
        mm.put(macro.getName(), macro);
        return mm;
    }

    public synchronized void addMacro(String name, String text) {
        JooneMacro macro;
        boolean oldEvent = false;
        if (this.macros.containsKey(name)) {
            macro = (JooneMacro)this.macros.get(name);
            oldEvent = macro.isEventMacro();
        } else {
            macro = new JooneMacro();
        }
        macro.setName(name);
        macro.setText(text);
        macro.setEventMacro(oldEvent);
        if (!this.macros.containsKey(name)) {
            this.macros.put(name, macro);
        }
    }

    public String getMacro(String name) {
        JooneMacro macro = (JooneMacro)this.macros.get(name);
        if (macro != null) {
            return macro.getText();
        }
        return null;
    }

    public boolean isEventMacro(String name) {
        JooneMacro macro = (JooneMacro)this.macros.get(name);
        if (macro != null) {
            return macro.isEventMacro();
        }
        return false;
    }

    public boolean removeMacro(String name) {
        JooneMacro macro = (JooneMacro)this.macros.get(name);
        if (macro != null) {
            if (macro.isEventMacro()) {
                return false;
            }
            this.macros.remove(name);
            return true;
        }
        return false;
    }

    public boolean renameMacro(String oldName, String newName) {
        JooneMacro macro = (JooneMacro)this.macros.get(oldName);
        if (macro != null) {
            if (macro.isEventMacro()) {
                return false;
            }
            this.macros.remove(oldName);
            this.addMacro(newName, macro.getText());
            return true;
        }
        return false;
    }

    public Hashtable getMacros() {
        return (Hashtable)this.macros.clone();
    }
}

