/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.util;

import org.joone.exception.JooneRuntimeException;
import org.joone.io.MemoryInputTokenizer;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class ParityInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(ParityInputSynapse.class);
    private int paritySize = 2;
    private double upperBit = 1.0;
    private double lowerBit = 0.0;

    @Override
    protected void initInputStream() throws JooneRuntimeException {
        this.setAdvancedColumnSelector("1-" + (this.paritySize + 1));
        this.setTokens(new MemoryInputTokenizer(this.createParityArray()));
    }

    public void setParitySize(int aSize) {
        this.paritySize = aSize;
    }

    public int getParitySize() {
        return this.paritySize;
    }

    public int getNumOfPatterns() {
        return (int)Math.pow(2.0, this.paritySize);
    }

    protected double[][] createParityArray() {
        int myPatterns = this.getNumOfPatterns();
        double[][] myParityInstance = new double[myPatterns][this.paritySize + 1];
        for (int i = 0; i < myPatterns; ++i) {
            int myDesiredOutput = 0;
            int myTemp = i;
            for (int j = 0; j < this.paritySize; ++j) {
                int myBit = myTemp % 2;
                myTemp /= 2;
                if (myBit == 1) {
                    myDesiredOutput = (myDesiredOutput + 1) % 2;
                }
                myParityInstance[i][j] = myBit == 0 ? this.getLowerBit() : this.getUpperBit();
            }
            myParityInstance[i][this.paritySize] = myDesiredOutput == 0 ? this.getLowerBit() : this.getUpperBit();
        }
        return myParityInstance;
    }

    public void setUpperBit(double aValue) {
        this.upperBit = aValue;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double aValue) {
        this.lowerBit = aValue;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }
}

