/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileOutputSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.net.NeuralNet;

public class XOR_using_NeuralNet
implements NeuralNetListener {
    private NeuralNet nnet = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    LinearLayer input;
    SigmoidLayer hidden;
    SigmoidLayer output;
    boolean singleThreadMode = true;
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] args) {
        XOR_using_NeuralNet xor = new XOR_using_NeuralNet();
        xor.initNeuralNet();
        xor.train();
        xor.interrogate();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(5000);
        monitor.setLearning(true);
        long initms = System.currentTimeMillis();
        this.nnet.getMonitor().setSingleThreadMode(this.singleThreadMode);
        this.nnet.go(true);
        System.out.println("Total time= " + (System.currentTimeMillis() - initms) + " ms");
    }

    private void interrogate() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1,2");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(1);
        monitor.setLearning(false);
        FileOutputSynapse foutput = new FileOutputSynapse();
        foutput.setFileName("/tmp/xorOut.txt");
        if (this.nnet != null) {
            this.nnet.addOutputSynapse(foutput);
            System.out.println(this.nnet.check());
            this.nnet.getMonitor().setSingleThreadMode(this.singleThreadMode);
            this.nnet.go();
        }
    }

    protected void initNeuralNet() {
        this.input = new LinearLayer();
        this.hidden = new SigmoidLayer();
        this.output = new SigmoidLayer();
        this.input.setRows(2);
        this.hidden.setRows(3);
        this.output.setRows(1);
        this.input.setLayerName("L.input");
        this.hidden.setLayerName("L.hidden");
        this.output.setLayerName("L.output");
        FullSynapse synapse_IH = new FullSynapse();
        FullSynapse synapse_HO = new FullSynapse();
        this.input.addOutputSynapse(synapse_IH);
        this.hidden.addInputSynapse(synapse_IH);
        this.hidden.addOutputSynapse(synapse_HO);
        this.output.addInputSynapse(synapse_HO);
        this.inputSynapse = new MemoryInputSynapse();
        this.input.addInputSynapse(this.inputSynapse);
        this.desiredOutputSynapse = new MemoryInputSynapse();
        TeachingSynapse trainer = new TeachingSynapse();
        trainer.setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(this.input, 0);
        this.nnet.addLayer(this.hidden, 1);
        this.nnet.addLayer(this.output, 2);
        this.nnet.setTeacher(trainer);
        this.output.addOutputSynapse(trainer);
        this.nnet.addNeuralNetListener(this);
    }

    @Override
    public void cicleTerminated(NeuralNetEvent e) {
    }

    @Override
    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        if (mon.getCurrentCicle() % 100 == 0) {
            System.out.println("Epoch: " + (mon.getTotCicles() - mon.getCurrentCicle()) + " RMSE:" + mon.getGlobalError());
        }
    }

    @Override
    public void netStarted(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        System.out.print("Network started for ");
        if (mon.isLearning()) {
            System.out.println("training.");
        } else {
            System.out.println("interrogation.");
        }
    }

    @Override
    public void netStopped(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        System.out.println("Network stopped. Last RMSE=" + mon.getGlobalError());
    }

    @Override
    public void netStoppedError(NeuralNetEvent e, String error) {
        System.out.println("Network stopped due the following error: " + error);
    }
}

