/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.editor.som;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.joone.samples.editor.som.ImageDrawer;
import org.joone.samples.editor.som.ImagePainter;

public class SOMImageTester
extends JFrame {
    private int DrawSizeX = 81;
    private int DrawSizeY = 81;
    private int ScaleSizeX = 9;
    private int ScaleSizeY = 9;
    private Vector imageHolder = new Vector();
    private Image downsamplePreviewImage = null;
    private BufferedImage downSample = new BufferedImage(this.getScaleSizeX(), this.getScaleSizeY(), 1);
    private BufferedImage drawImage = new BufferedImage(this.getDrawSizeX(), this.getDrawSizeY(), 1);
    private Vector idHolder = new Vector();
    private int currentImage = 0;
    private boolean alone;
    protected int downSampleLeft;
    protected int downSampleRight;
    protected int downSampleTop;
    protected int downSampleBottom;
    protected double ratioX;
    protected double ratioY;
    protected int[] pixelMap;
    private JButton ClearImageButton;
    private JPanel ControlPanel;
    private JButton DownSampleButton;
    private JPanel DownsamplePanel;
    private JButton HelpButton;
    private JTextField IDInputTextField;
    private JPanel ImageHolderPanel;
    private JLabel ImageIDLabel;
    private JLabel ImageNoLabel;
    private JScrollBar ImageScrollBar;
    private JPanel InfoPanel;
    private JButton NewImageButton;
    private JPanel PainterPanel;
    private JButton QuitButton;
    private JButton SaveImagesButton;

    public SOMImageTester() {
        this(false);
    }

    public SOMImageTester(boolean main) {
        this.alone = main;
        this.initComponents();
        this.setup();
        this.setSize(300, 350);
        this.setResizable(false);
    }

    private void initComponents() {
        this.ImageHolderPanel = new JPanel();
        this.PainterPanel = new ImagePainter();
        this.DownsamplePanel = new ImageDrawer();
        this.InfoPanel = new JPanel();
        this.ImageIDLabel = new JLabel();
        this.IDInputTextField = new JTextField();
        this.ImageNoLabel = new JLabel();
        this.DownSampleButton = new JButton();
        this.ImageScrollBar = new JScrollBar();
        this.ControlPanel = new JPanel();
        this.HelpButton = new JButton();
        this.NewImageButton = new JButton();
        this.ClearImageButton = new JButton();
        this.SaveImagesButton = new JButton();
        this.QuitButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SOMImageTester.this.exitForm(evt);
            }
        });
        this.ImageHolderPanel.setLayout(new GridLayout(1, 2));
        this.PainterPanel.setToolTipText("You can draw on this image.");
        this.ImageHolderPanel.add(this.PainterPanel);
        this.DownsamplePanel.setToolTipText("This contains the down sampled image.");
        this.ImageHolderPanel.add(this.DownsamplePanel);
        this.getContentPane().add((Component)this.ImageHolderPanel, "Center");
        this.InfoPanel.setLayout(new GridLayout(2, 2));
        this.ImageIDLabel.setText("Image ID");
        this.InfoPanel.add(this.ImageIDLabel);
        this.IDInputTextField.setText("1");
        this.InfoPanel.add(this.IDInputTextField);
        this.ImageNoLabel.setFont(new Font("Dialog", 1, 14));
        this.ImageNoLabel.setText("Image 1 of 1");
        this.ImageNoLabel.setToolTipText("The current image number.");
        this.InfoPanel.add(this.ImageNoLabel);
        this.DownSampleButton.setText("Down Sample");
        this.DownSampleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOMImageTester.this.DownSampleButtonActionPerformed(evt);
            }
        });
        this.InfoPanel.add(this.DownSampleButton);
        this.getContentPane().add((Component)this.InfoPanel, "North");
        this.ImageScrollBar.setMaximum(1);
        this.ImageScrollBar.setMinimum(1);
        this.ImageScrollBar.setToolTipText("Use scroll bar to scroll through images.");
        this.ImageScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                SOMImageTester.this.OnScrolled(evt);
            }
        });
        this.getContentPane().add((Component)this.ImageScrollBar, "East");
        this.ControlPanel.setLayout(new GridLayout(5, 2));
        this.ControlPanel.setBorder(new TitledBorder("Controls"));
        this.HelpButton.setText("Help");
        this.HelpButton.setToolTipText("Help on this application.");
        this.HelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOMImageTester.this.HelpButtonActionPerformed(evt);
            }
        });
        this.ControlPanel.add(this.HelpButton);
        this.NewImageButton.setText("New Image");
        this.NewImageButton.setToolTipText("Create a new image.");
        this.NewImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOMImageTester.this.NewImageButtonActionPerformed(evt);
            }
        });
        this.ControlPanel.add(this.NewImageButton);
        this.ClearImageButton.setText("Clear Image");
        this.ClearImageButton.setToolTipText("Clear the drawing from this image.");
        this.ClearImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOMImageTester.this.ClearImageButtonActionPerformed(evt);
            }
        });
        this.ControlPanel.add(this.ClearImageButton);
        this.SaveImagesButton.setText("Save Images");
        this.SaveImagesButton.setToolTipText("Save the images out to Joone format.");
        this.SaveImagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOMImageTester.this.SaveImagesButtonActionPerformed(evt);
            }
        });
        this.ControlPanel.add(this.SaveImagesButton);
        this.QuitButton.setText("Quit");
        this.QuitButton.setToolTipText("Quit this application.");
        this.QuitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOMImageTester.this.QuitButtonActionPerformed(evt);
            }
        });
        this.ControlPanel.add(this.QuitButton);
        this.getContentPane().add((Component)this.ControlPanel, "South");
        this.pack();
    }

    private void HelpButtonActionPerformed(ActionEvent evt) {
        String help1 = new String("This application allows the user to draw characters or images for recognition by a Joone neural network.");
        String help2 = new String("It is intended to test a SOM or Kohonen Network by providing an image recognition example.");
        String help3 = new String("The drawing image grid is 81 X 81 but the images saved in the file are 9x9 down sampled images.");
        String help4 = new String("The saved file has 81 inputs and an id.  The id can be used to identify the character.");
        String help5 = new String("Read the Editor's help pages to learn how to use this example.");
        JOptionPane.showMessageDialog(this, help1 + "\n" + help2 + "\n" + help3 + "\n" + help4 + "\n" + help5);
    }

    private void QuitButtonActionPerformed(ActionEvent evt) {
        this.exitTester();
    }

    private void SaveImagesButtonActionPerformed(ActionEvent evt) {
        this.SaveImagesOut();
    }

    private void NewImageButtonActionPerformed(ActionEvent evt) {
        this.NewImage();
    }

    private void ClearImageButtonActionPerformed(ActionEvent evt) {
        this.clearCurrentImage();
    }

    private void DownSampleButtonActionPerformed(ActionEvent evt) {
        this.downSample();
        this.repaint();
    }

    private void OnScrolled(AdjustmentEvent evt) {
        Integer id = null;
        if (evt.getAdjustmentType() == 5 && evt.getValue() <= this.imageHolder.size()) {
            try {
                id = new Integer(this.IDInputTextField.getText());
            }
            catch (NumberFormatException ex) {
                this.ImageScrollBar.setValue(this.ImageScrollBar.getValue() - this.ImageScrollBar.getUnitIncrement());
                JOptionPane.showMessageDialog(this, "ID must be an integer value.");
                return;
            }
            this.idHolder.set(this.currentImage - 1, id);
            this.currentImage = evt.getValue();
            this.IDInputTextField.setText("" + (Integer)this.idHolder.get(this.currentImage - 1));
            this.drawImage = (BufferedImage)this.imageHolder.get(this.currentImage - 1);
            ((ImagePainter)this.PainterPanel).setImageToEdit(this.drawImage);
            this.downSample();
            this.ImageNoLabel.setText("Image 1 of " + this.currentImage);
            this.repaint();
        }
    }

    private void exitForm(WindowEvent evt) {
        this.exitTester();
    }

    private void exitTester() {
        if (this.alone) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public void setup() {
        if (this.imageHolder != null) {
            this.drawImage.getGraphics().setColor(new Color(255, 255, 255));
            this.drawImage.getGraphics().fillRect(0, 0, this.drawImage.getWidth(), this.drawImage.getHeight());
            this.imageHolder.add(this.drawImage);
            ((ImagePainter)this.PainterPanel).setImageToEdit(this.drawImage);
            if (this.downsamplePreviewImage != null) {
                this.downsamplePreviewImage.getGraphics().setColor(Color.WHITE);
                this.downsamplePreviewImage.getGraphics().fillRect(0, 0, this.downsamplePreviewImage.getWidth(this), this.downsamplePreviewImage.getHeight(this));
                ((ImageDrawer)this.DownsamplePanel).setImageToDraw(this.downsamplePreviewImage);
            }
            this.idHolder.add(new Integer(1));
            this.currentImage = 1;
        }
        this.repaint();
    }

    public static void main(String[] args) {
        new SOMImageTester().show();
    }

    public int getDrawSizeX() {
        return this.DrawSizeX;
    }

    public void setDrawSizeX(int DrawSizeX) {
        this.DrawSizeX = DrawSizeX;
    }

    public int getDrawSizeY() {
        return this.DrawSizeY;
    }

    public void setDrawSizeY(int DrawSizeY) {
        this.DrawSizeY = DrawSizeY;
    }

    public int getScaleSizeX() {
        return this.ScaleSizeX;
    }

    public void setScaleSizeX(int ScaleSizeX) {
        this.ScaleSizeX = ScaleSizeX;
    }

    public int getScaleSizeY() {
        return this.ScaleSizeY;
    }

    public void setScaleSizeY(int ScaleSizeY) {
        this.ScaleSizeY = ScaleSizeY;
    }

    public void clearCurrentImage() {
        this.drawImage.getGraphics().setColor(Color.WHITE);
        this.drawImage.getGraphics().fillRect(0, 0, this.drawImage.getWidth(), this.drawImage.getHeight());
        this.downSample();
        this.repaint();
    }

    public void NewImage() {
        if (this.imageHolder != null && this.idHolder != null) {
            this.downSample = new BufferedImage(this.getScaleSizeX(), this.getScaleSizeY(), 1);
            this.drawImage = new BufferedImage(this.getDrawSizeX(), this.getDrawSizeY(), 1);
            this.clearCurrentImage();
            Integer cur_id = (Integer)this.idHolder.get(this.currentImage - 1);
            ++this.currentImage;
            this.imageHolder.add(this.drawImage);
            this.idHolder.add(cur_id);
            this.IDInputTextField.setText("" + cur_id);
            this.ImageScrollBar.setMaximum(this.currentImage);
            this.ImageScrollBar.setValue(this.currentImage);
            ((ImagePainter)this.PainterPanel).setImageToEdit(this.drawImage);
            ((ImageDrawer)this.DownsamplePanel).setImageToDraw(this.downsamplePreviewImage);
            this.ImageNoLabel.setText("Image 1 of " + this.currentImage);
            this.repaint();
        }
    }

    protected boolean hLineClear(int y) {
        int w = this.drawImage.getWidth(this);
        for (int i = 0; i < w; ++i) {
            if (this.pixelMap[y * w + i] == -1) continue;
            return false;
        }
        return true;
    }

    protected boolean vLineClear(int x) {
        int w = this.drawImage.getWidth(this);
        int h = this.drawImage.getHeight(this);
        for (int i = 0; i < h; ++i) {
            if (this.pixelMap[i * w + x] == -1) continue;
            return false;
        }
        return true;
    }

    protected void findBounds(int w, int h) {
        int x;
        int y;
        for (y = 0; y < h; ++y) {
            if (this.hLineClear(y)) continue;
            this.downSampleTop = y;
            break;
        }
        for (y = h - 1; y >= 0; --y) {
            if (this.hLineClear(y)) continue;
            this.downSampleBottom = y;
            break;
        }
        for (x = 0; x < w; ++x) {
            if (this.vLineClear(x)) continue;
            this.downSampleLeft = x;
            break;
        }
        for (x = w - 1; x >= 0; --x) {
            if (this.vLineClear(x)) continue;
            this.downSampleRight = x;
            break;
        }
    }

    protected boolean downSampleQuadrant(int x, int y) {
        int w = this.drawImage.getWidth(this);
        int startX = (int)((double)this.downSampleLeft + (double)x * this.ratioX);
        int startY = (int)((double)this.downSampleTop + (double)y * this.ratioY);
        int endX = (int)((double)startX + this.ratioX);
        int endY = (int)((double)startY + this.ratioY);
        for (int yy = startY; yy <= endY; ++yy) {
            for (int xx = startX; xx <= endX; ++xx) {
                int loc = xx + yy * w;
                if (this.pixelMap[loc] == -1) continue;
                return true;
            }
        }
        return false;
    }

    public void downSample() {
        int w = this.drawImage.getWidth(this);
        int h = this.drawImage.getHeight(this);
        PixelGrabber grabber = new PixelGrabber(this.drawImage, 0, 0, w, h, true);
        try {
            grabber.grabPixels();
            this.pixelMap = (int[])grabber.getPixels();
            this.findBounds(w, h);
            this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)this.downSample.getWidth();
            this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)this.downSample.getHeight();
            for (int y = 0; y < this.downSample.getHeight(); ++y) {
                for (int x = 0; x < this.downSample.getWidth(); ++x) {
                    if (this.downSampleQuadrant(x, y)) {
                        this.downSample.setRGB(x, y, Color.BLACK.getRGB());
                        continue;
                    }
                    this.downSample.setRGB(x, y, Color.WHITE.getRGB());
                }
            }
            this.downsamplePreviewImage = this.downSample.getScaledInstance(this.getDrawSizeX(), this.getDrawSizeY(), 1);
            if (this.downsamplePreviewImage != null) {
                ((ImageDrawer)this.DownsamplePanel).setImageToDraw(this.downsamplePreviewImage);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void SaveImagesOut() {
        FileOutputStream joone_file = null;
        DataOutputStream joone_out = null;
        JFileChooser choose = new JFileChooser();
        int result = choose.showSaveDialog(this);
        try {
            if (result == 0) {
                joone_file = new FileOutputStream(choose.getSelectedFile());
                joone_out = new DataOutputStream(joone_file);
                for (int i = 0; i < this.imageHolder.size(); ++i) {
                    this.drawImage = (BufferedImage)this.imageHolder.get(i);
                    this.downSample();
                    for (int y = 0; y < this.downSample.getHeight(); ++y) {
                        for (int x = 0; x < this.downSample.getWidth(); ++x) {
                            if (this.downSample.getRGB(x, y) == Color.BLACK.getRGB()) {
                                joone_out.writeBytes("1.0;");
                                continue;
                            }
                            joone_out.writeBytes("0.0;");
                        }
                    }
                    joone_out.writeBytes((Integer)this.idHolder.get(i) + "\n");
                }
            }
        }
        catch (IOException ex) {
            JOptionPane.showInternalMessageDialog(this, "An error occurred while trying to write to the file. Error is " + ex.toString());
        }
    }
}

