/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import org.joone.engine.InputPatternListener;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralLayer;
import org.joone.engine.OutputPatternListener;

public class NetCheck
implements Comparable {
    public static final int FATAL = 0;
    public static final int WARNING = 1;
    private int severity;
    private String message;
    private Object source;

    public NetCheck(int severityArg, String messageArg, Object objectArg) {
        this.setSeverity(severityArg);
        this.setMessage(messageArg);
        this.setSource(objectArg);
    }

    public String toString() {
        String className = this.getSource().getClass().getName();
        className = className.substring(1 + className.lastIndexOf("."));
        String instanceName = this.getSource() instanceof NeuralLayer ? ((NeuralLayer)this.getSource()).getLayerName() : (this.getSource() instanceof InputPatternListener ? ((InputPatternListener)this.getSource()).getName() : (this.getSource() instanceof OutputPatternListener ? ((OutputPatternListener)this.getSource()).getName() : (this.getSource() instanceof Monitor ? "Monitor" : this.getSource().toString())));
        StringBuffer checkMessage = new StringBuffer();
        if (this.isFatal()) {
            checkMessage.append("FATAL - ");
        } else if (this.isWarning()) {
            checkMessage.append("WARNING - ");
        }
        checkMessage.append(className);
        checkMessage.append(" - ");
        if (instanceName != null && !instanceName.trim().equals("")) {
            checkMessage.append(instanceName);
            checkMessage.append(" - ");
        }
        checkMessage.append(this.getMessage());
        return checkMessage.toString();
    }

    public boolean isWarning() {
        return this.getSeverity() == 1;
    }

    public boolean isFatal() {
        return this.getSeverity() == 0;
    }

    public int compareTo(Object o) {
        if (o instanceof NetCheck) {
            NetCheck nc = (NetCheck)o;
            return this.toString().compareTo(nc.toString());
        }
        return 0;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }
}

