/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.listeners;

import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.Synapse;
import org.joone.engine.listeners.ConvergenceObserver;
import org.joone.net.NeuralNet;

public class DeltaBasedConvergenceObserver
extends ConvergenceObserver {
    private double size = 0.0;
    private int cycles = 5;
    private int cycleCounter = 0;
    private NeuralNet net;

    public void setSize(double aSize) {
        this.size = aSize;
    }

    public double getSize() {
        return this.size;
    }

    public void setCycles(int aCylces) {
        this.cycles = aCylces;
    }

    public int getCycles() {
        return this.cycles;
    }

    @Override
    public void setNeuralNet(NeuralNet aNet) {
        this.net = aNet;
    }

    @Override
    public NeuralNet getNeuralNet() {
        return this.net;
    }

    @Override
    protected void manageStop(Monitor mon) {
    }

    @Override
    protected void manageCycle(Monitor mon) {
    }

    @Override
    protected void manageStart(Monitor mon) {
    }

    @Override
    protected void manageError(Monitor mon) {
        if (this.cycles <= 0) {
            return;
        }
        for (int i = 0; i < this.net.getLayers().size(); ++i) {
            Layer myLayer = (Layer)this.net.getLayers().get(i);
            Matrix myBiases = myLayer.getBias();
            for (int b = 0; b < myBiases.getM_rows(); ++b) {
                if (myBiases == null || this.isConvergence(myBiases)) continue;
                this.cycleCounter = 0;
                this.disableCurrentConvergence = false;
                return;
            }
            for (int s = 0; s < myLayer.getAllOutputs().size(); ++s) {
                Matrix myWeights;
                if (!(myLayer.getAllOutputs().get(s) instanceof Synapse) || (myWeights = ((Synapse)myLayer.getAllOutputs().get(s)).getWeights()) == null || this.isConvergence(myWeights)) continue;
                this.cycleCounter = 0;
                this.disableCurrentConvergence = false;
                return;
            }
        }
        ++this.cycleCounter;
        if (this.cycleCounter == this.cycles) {
            if (!this.disableCurrentConvergence) {
                this.fireNetConverged(mon);
            }
            this.cycleCounter = 0;
        }
    }

    protected boolean isConvergence(Matrix aMatrix) {
        for (int r = 0; r < aMatrix.getM_rows(); ++r) {
            for (int c = 0; c < aMatrix.getM_cols(); ++c) {
                if (!(Math.abs(aMatrix.delta[r][c]) > this.size)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void manageStopError(Monitor mon, String msgErr) {
    }
}

