/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import java.util.TreeSet;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.engine.learning.AbstractTeacherSynapse;
import org.joone.engine.learning.ComparingElement;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;
import org.joone.net.NetCheck;

public class TeachingSynapse
implements ComparingElement {
    protected AbstractTeacherSynapse theTeacherSynapse;
    private LinearLayer theLinearLayer;
    private boolean enabled = true;
    private boolean outputFull = false;
    private AbstractTeacherSynapse theTeacherToUse = null;
    private StreamInputSynapse desired;
    private Monitor monitor;
    private String name;
    private static final long serialVersionUID = -8893181016305737666L;

    public TeachingSynapse() {
    }

    public TeachingSynapse(TeacherSynapse aTeacher) {
        this.theTeacherToUse = aTeacher;
    }

    @Override
    public void fwdPut(Pattern pattern) {
        Monitor mon = this.getMonitor();
        if (!mon.isLearning() && !mon.isValidation()) {
            return;
        }
        if (!mon.isSingleThreadMode() && !this.getTheLinearLayer().isRunning()) {
            this.getTheLinearLayer().start();
        }
        boolean firstTime = this.getTheTeacherSynapse().getSeenPatterns() == 0;
        this.getTheTeacherSynapse().fwdPut(pattern);
        if (mon.isSingleThreadMode()) {
            if (pattern.getCount() == -1) {
                this.getTheLinearLayer().fwdRun(null);
            }
            if (pattern.getCount() == 1 && !firstTime) {
                this.getTheLinearLayer().fwdRun(null);
            }
        }
    }

    @Override
    public StreamInputSynapse getDesired() {
        return this.desired;
    }

    @Override
    public int getInputDimension() {
        return this.getTheTeacherSynapse().getInputDimension();
    }

    @Override
    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public LinearLayer getTheLinearLayer() {
        if (this.theLinearLayer == null) {
            this.theLinearLayer = new LinearLayer();
            this.theLinearLayer.setLayerName("(R)MSE Layer");
            if (this.monitor != null) {
                this.theLinearLayer.setMonitor(this.monitor);
            }
            this.theLinearLayer.setRows(1);
            this.theLinearLayer.addInputSynapse(this.getTheTeacherSynapse());
        }
        return this.theLinearLayer;
    }

    public AbstractTeacherSynapse getTheTeacherSynapse() {
        if (this.theTeacherSynapse == null) {
            if (this.theTeacherToUse != null) {
                this.theTeacherSynapse = this.theTeacherToUse;
            } else {
                this.theTeacherSynapse = new TeacherSynapse();
                this.theTeacherSynapse.setName("Teacher Synapse");
            }
            if (this.monitor != null) {
                this.theTeacherSynapse.setMonitor(this.monitor);
            }
        }
        return this.theTeacherSynapse;
    }

    @Override
    public Pattern revGet() {
        return this.getTheTeacherSynapse().revGet();
    }

    @Override
    public boolean setDesired(StreamInputSynapse fn) {
        this.desired = fn;
        if (this.getTheTeacherSynapse().setDesired(fn)) {
            if (this.monitor != null && this.desired != null) {
                this.desired.setMonitor(this.monitor);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addResultSynapse(OutputPatternListener listener) {
        if (listener != null) {
            return this.getTheLinearLayer().addOutputSynapse(listener);
        }
        return false;
    }

    @Override
    public void removeResultSynapse(OutputPatternListener listener) {
        if (listener != null) {
            this.getTheLinearLayer().removeOutputSynapse(listener);
        }
    }

    @Override
    public void setInputDimension(int newInputDimension) {
        this.getTheTeacherSynapse().setInputDimension(newInputDimension);
    }

    @Override
    public void setMonitor(Monitor newMonitor) {
        this.monitor = newMonitor;
        if (this.theTeacherSynapse != null) {
            this.theTeacherSynapse.setMonitor(newMonitor);
        }
        if (this.theLinearLayer != null) {
            this.theLinearLayer.setMonitor(newMonitor);
        }
        if (this.desired != null) {
            this.desired.setMonitor(newMonitor);
        }
    }

    public void stop() {
        this.getTheLinearLayer().stop();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    protected void forward(double[] pattern) {
    }

    protected void setArrays(int rows, int cols) {
    }

    protected void setDimensions(int rows, int cols) {
    }

    protected void backward(double[] pattern) {
    }

    public void setTheTeacherSynapse(TeacherSynapse newTheTeacherSynapse) {
        this.theTeacherSynapse = newTheTeacherSynapse;
    }

    public void setTheLinearLayer(LinearLayer newTheLinearLayer) {
        this.theLinearLayer = newTheLinearLayer;
    }

    @Override
    public void resetInput() {
        this.getTheTeacherSynapse().resetInput();
    }

    @Override
    public TreeSet check() {
        TreeSet<NetCheck> checks = new TreeSet<NetCheck>();
        if (!this.isOutputFull()) {
            checks.add(new NetCheck(0, "the Teacher seems to be not attached", this));
        }
        if (this.theLinearLayer != null) {
            checks.addAll(this.setErrorSource(this.theLinearLayer.check()));
        }
        if (this.theTeacherSynapse != null) {
            checks.addAll(this.setErrorSource(this.theTeacherSynapse.check()));
        }
        return checks;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getTheTeacherSynapse().setEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public boolean isOutputFull() {
        return this.outputFull;
    }

    @Override
    public void setOutputFull(boolean outputFull) {
        this.outputFull = outputFull;
    }

    @Override
    public void init() {
        if (this.theTeacherSynapse != null) {
            this.theTeacherSynapse.init();
        }
    }

    private TreeSet setErrorSource(TreeSet errors) {
        if (!errors.isEmpty()) {
            for (NetCheck nc : errors) {
                if (nc.getSource() instanceof Monitor || nc.getSource() instanceof StreamInputSynapse || nc.getSource() instanceof StreamOutputSynapse) continue;
                nc.setSource(this);
            }
        }
        return errors;
    }
}

