/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import java.io.IOException;
import java.util.TreeSet;
import org.joone.engine.Fifo;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public abstract class AbstractTeacherSynapse
extends Synapse {
    private static final long serialVersionUID = -3501303723175798936L;
    protected static final ILogger log = LoggerFactory.getLogger(AbstractTeacherSynapse.class);
    private transient boolean firstTime = true;
    private transient int patterns = 0;
    protected StreamInputSynapse desired;
    protected transient Fifo error;

    public AbstractTeacherSynapse() {
        this.setFirstTime(true);
    }

    protected void setFirstTime(boolean aValue) {
        this.firstTime = aValue;
    }

    protected boolean isFirstTime() {
        return this.firstTime;
    }

    @Override
    protected void backward(double[] pattern) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushError(double error, int count) {
        double[] cost = new double[]{error};
        Pattern ptnErr = new Pattern(cost);
        ptnErr.setCount(count);
        AbstractTeacherSynapse abstractTeacherSynapse = this;
        synchronized (abstractTeacherSynapse) {
            this.getError().push(ptnErr);
            this.notify();
        }
    }

    private Fifo getError() {
        if (this.error == null) {
            this.error = new Fifo();
        }
        return this.error;
    }

    protected void stopTheNet() {
        this.pushError(0.0, -1);
        this.patterns = 0;
        this.setFirstTime(true);
        if (this.getMonitor() != null) {
            new NetStoppedEventNotifier(this.getMonitor()).start();
        }
    }

    protected int getSeenPatterns() {
        return this.patterns;
    }

    protected void setSeenPatterns(int aValue) {
        this.patterns = aValue;
    }

    protected void incSeenPatterns() {
        ++this.patterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern fwdGet() {
        AbstractTeacherSynapse abstractTeacherSynapse = this;
        synchronized (abstractTeacherSynapse) {
            while (this.getError().empty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
            Pattern errPatt = (Pattern)this.error.pop();
            this.notify();
            return errPatt;
        }
    }

    public StreamInputSynapse getDesired() {
        return this.desired;
    }

    public boolean setDesired(StreamInputSynapse newDesired) {
        if (newDesired == null) {
            if (this.desired != null) {
                this.desired.setInputFull(false);
            }
            this.desired = newDesired;
        } else {
            if (newDesired.isInputFull()) {
                return false;
            }
            this.desired = newDesired;
            this.desired.setStepCounter(false);
            this.desired.setOutputDimension(this.getInputDimension());
            this.desired.setInputFull(true);
        }
        return true;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.setFirstTime(true);
        if (this.getMonitor() != null) {
            this.getMonitor().setSupervised(true);
        }
        return this;
    }

    @Override
    protected void setArrays(int rows, int cols) {
    }

    @Override
    protected void setDimensions(int rows, int cols) {
    }

    @Override
    public void setInputDimension(int newInputDimension) {
        super.setInputDimension(newInputDimension);
        if (this.getDesired() != null) {
            this.getDesired().setOutputDimension(newInputDimension);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setSeenPatterns(0);
        this.setFirstTime(true);
        if (this.getDesired() != null) {
            this.getDesired().reset();
        }
    }

    public void resetInput() {
        if (this.getDesired() != null) {
            this.getDesired().resetInput();
        }
    }

    @Override
    public void setMonitor(Monitor newMonitor) {
        super.setMonitor(newMonitor);
        if (this.getMonitor() != null) {
            this.getMonitor().setSupervised(true);
        }
    }

    public void netStoppedError() {
        this.pushError(0.0, -1);
        this.setSeenPatterns(0);
        this.setFirstTime(true);
        this.reset();
    }

    @Override
    public void init() {
        super.init();
        this.setSeenPatterns(0);
        this.setFirstTime(true);
        if (this.getDesired() != null) {
            this.getDesired().init();
        }
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.getDesired() == null) {
            checks.add(new NetCheck(0, "Desired Input has not been set.", this));
        } else {
            checks.addAll(this.getDesired().check());
        }
        return checks;
    }

    @Override
    public void revPut(Pattern pattern) {
    }

    @Override
    public Pattern revGet() {
        if (this.isEnabled()) {
            return super.fwdGet();
        }
        return null;
    }

    @Override
    public void fwdPut(Pattern pattern) {
        int step = pattern.getCount();
        if (!(this.getMonitor().isSingleThreadMode() || this.getMonitor() != null && this.isEnabled())) {
            if (step == -1) {
                this.stopTheNet();
            }
            return;
        }
        super.fwdPut(pattern);
        if (step != -1) {
            if (!this.getMonitor().isLearningCicle(step)) {
                this.items = 0;
            }
        } else {
            this.items = 0;
        }
    }

    @Override
    protected void forward(double[] pattern) {
        double[] pDesired;
        if (this.m_pattern.getCount() == 1 || this.m_pattern.getCount() == -1) {
            try {
                this.desired.gotoFirstLine();
                if (!this.isFirstTime() && this.getSeenPatterns() == this.getMonitor().getNumOfPatterns()) {
                    double myGlobalError = this.calculateGlobalError();
                    this.pushError(myGlobalError, this.getMonitor().getTotCicles() - this.getMonitor().getCurrentCicle());
                    this.getMonitor().setGlobalError(myGlobalError);
                    this.epochFinished();
                    this.setSeenPatterns(0);
                }
            }
            catch (IOException ioe) {
                new NetErrorManager(this.getMonitor(), "TeacherSynapse: IOException while forwarding the influx. Message is : " + ioe.getMessage());
                return;
            }
        }
        if (this.m_pattern.getCount() == -1) {
            if (!this.getMonitor().isSingleThreadMode()) {
                this.stopTheNet();
            } else {
                this.pushError(0.0, -1);
            }
            return;
        }
        this.setFirstTime(false);
        this.outs = new double[pattern.length];
        Pattern pattDesired = this.desired.fwdGet();
        if (this.m_pattern.getCount() != pattDesired.getCount()) {
            try {
                this.desired.gotoLine(this.m_pattern.getCount());
                pattDesired = this.desired.fwdGet();
                if (this.m_pattern.getCount() != pattDesired.getCount()) {
                    new NetErrorManager(this.getMonitor(), "TeacherSynapse: No matching patterns - input#" + this.m_pattern.getCount() + " desired#" + pattDesired.getCount());
                    return;
                }
            }
            catch (IOException ioe) {
                new NetErrorManager(this.getMonitor(), "TeacherSynapse: IOException while forwarding the influx. Message is : " + ioe.getMessage());
                return;
            }
        }
        if (this.getMonitor().getPreLearning() < this.m_pattern.getCount() && (pDesired = pattDesired.getArray()) != null) {
            if (pDesired.length != this.outs.length) {
                log.warn("Size output pattern mismatches size desired pattern. Zero-valued desired pattern sized error pattern will be backpropagated.");
                this.outs = new double[pDesired.length];
            } else {
                this.constructErrorPattern(pDesired, pattern);
            }
        }
        this.incSeenPatterns();
    }

    protected void constructErrorPattern(double[] aDesired, double[] anOutput) {
        for (int x = 0; x < aDesired.length; ++x) {
            this.outs[x] = this.calculateError(aDesired[x], anOutput[x], x);
        }
    }

    protected abstract double calculateError(double var1, double var3, int var5);

    protected abstract double calculateGlobalError();

    protected void epochFinished() {
    }
}

