/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.InputPatternListener;
import org.joone.engine.LearnableSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.inspection.Inspectable;
import org.joone.inspection.implementations.WeightsInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public abstract class Synapse
implements InputPatternListener,
OutputPatternListener,
LearnableSynapse,
Serializable,
Inspectable {
    private static final ILogger log = LoggerFactory.getLogger(Synapse.class);
    private static int synapseCount = 0;
    private String fieldName = "Synapse " + ++synapseCount;
    private double learningRate = 0.0;
    private double momentum = 0.0;
    private int inputDimension = 0;
    private int outputDimension = 0;
    private boolean inputFull;
    private boolean outputFull;
    private Monitor monitor;
    private int ignoreBefore = -1;
    private boolean loopBack = false;
    protected Matrix array;
    protected int m_batch = 0;
    protected boolean enabled = true;
    protected transient double[] inps = null;
    protected transient double[] outs = null;
    protected transient double[] bouts;
    protected transient int items = 0;
    protected transient int bitems = 0;
    protected transient Pattern m_pattern;
    protected transient Pattern b_pattern;
    protected transient int count = 0;
    protected transient boolean notFirstTime;
    protected transient boolean notFirstTimeB;
    protected transient Learner myLearner = null;
    protected volatile transient Object fwdLock = null;
    protected volatile transient Object revLock = null;
    protected boolean learnable = false;
    private static final long serialVersionUID = -5892822057908231022L;

    public void addNoise(double amplitude) {
        if (this.array != null) {
            this.array.addNoise(amplitude);
        }
    }

    public void randomize(double amplitude) {
        if (this.array != null) {
            this.array.initialize();
        }
    }

    protected abstract void backward(double[] var1);

    public boolean canCountSteps() {
        return false;
    }

    protected abstract void forward(double[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern fwdGet() {
        if (!this.isEnabled()) {
            return null;
        }
        Object object = this.getFwdLock();
        synchronized (object) {
            if (this.notFirstTime || !this.loopBack) {
                while (this.items == 0) {
                    try {
                        this.fwdLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.reset();
                        this.fwdLock.notify();
                        return null;
                    }
                }
                --this.items;
                this.m_pattern.setArray(this.outs);
                if (this.isLoopBack()) {
                    this.m_pattern.setCount(0);
                }
                this.fwdLock.notify();
                return this.m_pattern;
            }
            this.count = 0;
            this.bitems = 0;
            this.items = 0;
            this.notFirstTime = true;
            this.fwdLock.notify();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fwdPut(Pattern pattern) {
        if (this.isEnabled()) {
            Object object = this.getFwdLock();
            synchronized (object) {
                while (this.items > 0) {
                    try {
                        this.fwdLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.reset();
                        this.fwdLock.notify();
                        return;
                    }
                }
                this.m_pattern = pattern;
                this.count = this.m_pattern.getCount();
                this.inps = pattern.getArray();
                this.forward(this.inps);
                ++this.items;
                this.fwdLock.notify();
            }
        }
    }

    @Override
    public void reset() {
        this.bitems = 0;
        this.items = 0;
        this.notFirstTime = false;
        this.notFirstTimeB = false;
    }

    public int getIgnoreBefore() {
        return this.ignoreBefore;
    }

    @Override
    public int getInputDimension() {
        return this.inputDimension;
    }

    @Override
    public double getLearningRate() {
        if (this.monitor != null) {
            return this.monitor.getLearningRate();
        }
        return 0.0;
    }

    @Override
    public double getMomentum() {
        if (this.monitor != null) {
            return this.monitor.getMomentum();
        }
        return 0.0;
    }

    @Override
    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public int getOutputDimension() {
        return this.outputDimension;
    }

    protected Object readResolve() {
        this.setArrays(this.getInputDimension(), this.getOutputDimension());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pattern revGet() {
        if (!this.isEnabled()) {
            return null;
        }
        Object object = this.getRevLock();
        synchronized (object) {
            if (this.notFirstTimeB || !this.loopBack) {
                while (this.bitems == 0) {
                    try {
                        this.revLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.reset();
                        this.revLock.notify();
                        return null;
                    }
                }
                --this.bitems;
                this.b_pattern.setArray(this.bouts);
                this.revLock.notify();
                return this.b_pattern;
            }
            this.revLock.notify();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revPut(Pattern pattern) {
        if (this.isEnabled()) {
            Object object = this.getRevLock();
            synchronized (object) {
                while (this.bitems > 0) {
                    try {
                        this.revLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.reset();
                        this.revLock.notify();
                        return;
                    }
                }
                this.b_pattern = pattern;
                this.count = this.b_pattern.getCount();
                this.backward(pattern.getArray());
                ++this.bitems;
                this.notFirstTimeB = true;
                this.revLock.notify();
            }
        }
    }

    protected abstract void setArrays(int var1, int var2);

    protected abstract void setDimensions(int var1, int var2);

    public void setIgnoreBefore(int newIgnoreBefore) {
        this.ignoreBefore = newIgnoreBefore;
    }

    @Override
    public void setInputDimension(int newInputDimension) {
        if (this.inputDimension != newInputDimension) {
            this.inputDimension = newInputDimension;
            this.setDimensions(newInputDimension, -1);
        }
    }

    public void setLearningRate(double newLearningRate) {
        this.learningRate = newLearningRate;
    }

    public void setMomentum(double newMomentum) {
        this.momentum = newMomentum;
    }

    @Override
    public void setMonitor(Monitor newMonitor) {
        this.monitor = newMonitor;
        if (this.monitor != null) {
            this.setLearningRate(this.monitor.getLearningRate());
            this.setMomentum(this.monitor.getMomentum());
        }
    }

    @Override
    public void setName(String name) {
        this.fieldName = name;
    }

    @Override
    public void setOutputDimension(int newOutputDimension) {
        if (this.outputDimension != newOutputDimension) {
            this.outputDimension = newOutputDimension;
            this.setDimensions(-1, newOutputDimension);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public void setLoopBack(boolean loopBack) {
        this.loopBack = loopBack;
    }

    @Override
    public TreeSet check() {
        TreeSet checks = new TreeSet();
        return checks;
    }

    @Override
    public Collection Inspections() {
        ArrayList<WeightsInspection> col = new ArrayList<WeightsInspection>();
        col.add(new WeightsInspection(this.array));
        return col;
    }

    @Override
    public String InspectableTitle() {
        return this.getName();
    }

    @Override
    public boolean isInputFull() {
        return this.inputFull;
    }

    @Override
    public void setInputFull(boolean inputFull) {
        this.inputFull = inputFull;
    }

    @Override
    public boolean isOutputFull() {
        return this.outputFull;
    }

    @Override
    public void setOutputFull(boolean outputFull) {
        this.outputFull = outputFull;
    }

    @Override
    public Matrix getWeights() {
        return this.array;
    }

    @Override
    public void setWeights(Matrix newWeights) {
        this.array = newWeights;
    }

    @Override
    public Learner getLearner() {
        if (!this.learnable) {
            return null;
        }
        return this.getMonitor().getLearner();
    }

    @Override
    public void initLearner() {
        this.myLearner = this.getLearner();
        if (this.myLearner != null) {
            this.myLearner.registerLearnable(this);
        }
    }

    protected Object getFwdLock() {
        if (this.fwdLock == null) {
            this.fwdLock = new Object();
        }
        return this.fwdLock;
    }

    protected Object getRevLock() {
        if (this.revLock == null) {
            this.revLock = new Object();
        }
        return this.revLock;
    }

    @Override
    public void init() {
        this.initLearner();
        this.getFwdLock();
        this.getRevLock();
    }
}

