/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit.inspection;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.joone.inspection.Inspectable;
import org.joone.inspection.Inspection;

public class InspectionFrame
extends JFrame {
    Collection inspections = new ArrayList();
    JTabbedPane center;
    JTable[] tables;

    public InspectionFrame(Inspectable inspectableArg) {
        Iconkit kit = Iconkit.instance();
        final Collection copycol = inspectableArg.Inspections();
        if (kit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image img = kit.loadImageResource("/org/joone/images/JooneIcon.gif");
        this.setIconImage(img);
        if (inspectableArg != null) {
            this.inspections = inspectableArg.Inspections();
            this.setTitle("Inspection - " + inspectableArg.InspectableTitle());
        } else {
            this.setTitle("Inspection");
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JButton close = new JButton("Close");
        close.setToolTipText("Close the inspection frame");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectionFrame.this.dispose();
            }
        });
        JButton copybutton = new JButton("Copy");
        copybutton.setToolTipText("Copy data as tab delimeted");
        copybutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                String s = new String("");
                if (copycol != null) {
                    for (Object o : copycol) {
                        if (!(o instanceof Inspection)) continue;
                        Inspection inspection = (Inspection)o;
                        Component comp = InspectionFrame.this.makeTable(inspection);
                        try {
                            if (!comp.getClass().isInstance(new JTable())) continue;
                            JTable tab = (JTable)comp;
                            int f = inspection.rowNumbers() ? 1 : 0;
                            for (int i = 0; i < tab.getRowCount(); ++i) {
                                for (int j = f; j < tab.getColumnCount(); ++j) {
                                    if (j > f) {
                                        s = s + "\t";
                                    }
                                    s = s + tab.getModel().getValueAt(i, j).toString();
                                }
                                s = s + "\n";
                            }
                            StringSelection contents = new StringSelection(s);
                            cb.setContents(contents, null);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        });
        JButton pastebutton = new JButton("Paste");
        pastebutton.setToolTipText("Paste data from tab delimeted source");
        pastebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = cb.getContents(null);
                if (contents != null) {
                    try {
                        String s = (String)contents.getTransferData(DataFlavor.stringFlavor);
                        StringReader sr = new StringReader(s);
                        LineNumberReader lnr = new LineNumberReader(sr);
                        int curr = InspectionFrame.this.center.getSelectedIndex();
                        Object[] arr = InspectionFrame.this.inspections.toArray();
                        Inspection inspection = (Inspection)arr[curr];
                        Object[][] newValues = inspection.getComponent();
                        if (newValues == null) {
                            return;
                        }
                        String line = null;
                        for (int iLine = 0; (line = lnr.readLine()) != null && iLine < newValues.length; ++iLine) {
                            StringTokenizer st = new StringTokenizer(line, " ;,\t\n\r\f");
                            int iCol = 0;
                            if (inspection.rowNumbers()) {
                                iCol = 1;
                            }
                            while (st.hasMoreTokens() && iCol < newValues[0].length) {
                                String token = st.nextToken();
                                try {
                                    Double val = new Double(token);
                                    newValues[iLine][iCol] = val;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                ++iCol;
                            }
                        }
                        inspection.setComponent(newValues);
                        InspectionFrame.this.center.removeTabAt(curr);
                        Component pan = InspectionFrame.this.createPanel(InspectionFrame.this.makeTable(inspection));
                        InspectionFrame.this.center.insertTab(inspection.getTitle(), null, pan, null, curr);
                        InspectionFrame.this.center.setSelectedIndex(curr);
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                }
            }
        });
        JPanel east = new JPanel();
        east.setLayout(new GridLayout(6, 1));
        east.add(close);
        east.add(copybutton);
        east.add(pastebutton);
        contentPane.add((Component)east, "East");
        this.center = new JTabbedPane();
        if (inspectableArg == null) {
            this.addTab(this.center, "error", new JLabel("Inspectable object is null."));
        } else {
            Collection col = inspectableArg.Inspections();
            if (col == null) {
                this.addTab(this.center, "Error", new JLabel("Inspectable object Collection is null."));
            } else {
                for (Object o : col) {
                    if (o instanceof Inspection) {
                        Inspection inspection = (Inspection)o;
                        String title = inspection.getTitle();
                        this.addTab(this.center, title, this.makeTable(inspection));
                        continue;
                    }
                    this.addTab(this.center, "Error", new Label("Object is not an Inspection."));
                }
            }
        }
        contentPane.add((Component)this.center, "Center");
    }

    private void addTab(JTabbedPane jTabbedPane, String title, Component component) {
        jTabbedPane.addTab(title, this.createPanel(component));
    }

    private Component createPanel(Component component) {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(component);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        return jScrollPane;
    }

    @Override
    public void show() {
        this.pack();
        if (this.getWidth() < 250) {
            this.setSize(250, this.getHeight());
        }
        if (this.getWidth() > 500) {
            this.setSize(500, this.getHeight());
        }
        if (this.getHeight() > 200) {
            this.setSize(this.getWidth(), 200);
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        super.show();
    }

    private Component makeTable(Inspection inspection) {
        Object[][] array = inspection.getComponent();
        Object[] names = inspection.getNames();
        boolean rowsNumber = inspection.rowNumbers();
        if (array != null && names != null) {
            JTable jTable = new JTable(array, names);
            if (rowsNumber) {
                TableColumn col = jTable.getColumnModel().getColumn(0);
                DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
                renderer.setToolTipText("Row Number");
                renderer.setBackground(new Color(178, 178, 255));
                col.setCellRenderer(renderer);
            }
            jTable.setAutoResizeMode(2);
            jTable.doLayout();
            jTable.setEnabled(false);
            return jTable;
        }
        return new JLabel("There are no values set for this item.");
    }
}

