/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.joone.edit.ToolElement;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ToolsSAXParser
extends DefaultHandler {
    private static final ILogger log = LoggerFactory.getLogger(ToolsSAXParser.class);
    protected Vector elements;

    public ToolsSAXParser(InputStream xmlFile) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(xmlFile, (DefaultHandler)this);
        }
        catch (Throwable t) {
            log.error("Problem while parsing the XML document with the SAXParser", t);
        }
    }

    @Override
    public void startElement(String name, String sName, String qName, Attributes attrs) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        ToolElement te = new ToolElement(eName);
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String aName = attrs.getLocalName(i);
                if ("".equals(aName)) {
                    aName = attrs.getQName(i);
                }
                te.setParam(aName, attrs.getValue(i));
            }
        }
        this.elements.addElement(te);
    }

    public Vector getElements() {
        return this.elements;
    }

    @Override
    public void startDocument() throws SAXException {
        this.elements = new Vector();
    }
}

