/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ConnectionHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.joone.edit.ConcreteGenericFigure;
import org.joone.edit.GenericFigure;
import org.joone.edit.LayerConnection;
import org.joone.edit.UpdatableNumberTextFigure;
import org.joone.edit.UpdatableTextFigure;
import org.joone.edit.Wrapper;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.OutputPatternListener;

public class LayerFigure
extends ConcreteGenericFigure {
    protected Vector fPostConn;
    protected Vector fPreConn;
    protected Layer myLayer;
    private static final long serialVersionUID = -1148000139027412009L;

    @Override
    protected void initContent() {
        this.fPostConn = new Vector();
        this.fPreConn = new Vector();
        Font f = new Font("Helvetica", 0, 12);
        Font fb = new Font("Helvetica", 1, 12);
        this.myLayer = (Layer)this.createLayer();
        UpdatableTextFigure name = new UpdatableTextFigure(){

            @Override
            public void setText(String newText) {
                super.setText(newText);
                Layer ly = (Layer)LayerFigure.this.getLayer();
                ly.setLayerName(newText);
            }

            @Override
            public void update() {
                Layer ly = (Layer)LayerFigure.this.getLayer();
                this.setText(ly.getLayerName());
            }
        };
        name.setFont(fb);
        name.setText("Layer " + ++numLayers);
        name.setAttribute("TextColor", Color.blue);
        this.add(name);
        UpdatableNumberTextFigure inputDim = new UpdatableNumberTextFigure(){

            @Override
            public void setText(String newText) {
                super.setText(newText);
                Layer ly = (Layer)LayerFigure.this.getLayer();
                ly.setRows(Integer.parseInt(newText));
            }

            @Override
            public void update() {
                Layer ly = (Layer)LayerFigure.this.getLayer();
                this.setValue(ly.getRows());
            }
        };
        inputDim.setValue(1);
        inputDim.setFont(f);
        this.add(inputDim);
    }

    public boolean hasCycle(Figure start) {
        if (start == this) {
            return true;
        }
        Enumeration i = this.fPreConn.elements();
        while (i.hasMoreElements()) {
            if (!((LayerFigure)i.nextElement()).hasCycle(start)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        this.writeConn(dw, this.fPreConn);
        this.writeConn(dw, this.fPostConn);
    }

    public void writeConn(StorableOutput dw, Vector v) {
        dw.writeInt(v.size());
        Enumeration i = v.elements();
        while (i.hasMoreElements()) {
            dw.writeStorable((Storable)i.nextElement());
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fPreConn = this.readConn(dr);
        this.fPostConn = this.readConn(dr);
    }

    public Vector readConn(StorableInput dr) throws IOException {
        int size = dr.readInt();
        Vector<Storable> v = new Vector<Storable>(size);
        for (int i = 0; i < size; ++i) {
            v.addElement(dr.readStorable());
        }
        return v;
    }

    public void removePostConn(LayerFigure figure) {
        this.fPostConn.removeElement(figure);
    }

    public void removePreConn(LayerFigure figure) {
        this.fPreConn.removeElement(figure);
    }

    public void removePostConn(LayerFigure figure, OutputPatternListener conn) {
        this.removePostConn(figure);
        Layer ly = (Layer)this.getLayer();
        if (ly != null) {
            ly.removeOutputSynapse(conn);
        }
    }

    public void removePreConn(LayerFigure figure, InputPatternListener conn) {
        this.removePreConn(figure);
        Layer ly = (Layer)this.getLayer();
        if (ly != null) {
            ly.removeInputSynapse(conn);
        }
    }

    public void addPostConn(LayerFigure figure, OutputPatternListener conn) {
        if (!this.fPostConn.contains(figure)) {
            this.fPostConn.addElement(figure);
            Layer ly = (Layer)this.getLayer();
            if (ly != null) {
                ly.addOutputSynapse(conn);
            }
        }
    }

    public boolean addPreConn(LayerFigure figure, InputPatternListener conn) {
        if (!this.fPreConn.contains(figure)) {
            this.fPreConn.addElement(figure);
            Layer ly = (Layer)this.getLayer();
            if (ly != null) {
                ly.addInputSynapse(conn);
            }
            return true;
        }
        return false;
    }

    public void setLayer(Object newMyLayer) {
        this.myLayer = (Layer)newMyLayer;
    }

    @Override
    public boolean canConnect(GenericFigure start, ConnectionFigure conn) {
        return true;
    }

    public static void setNumLayers(int newValue) {
        numLayers = newValue;
    }

    @Override
    public Wrapper getWrapper() {
        Layer ly = (Layer)this.getLayer();
        return new Wrapper(this, ly, ly.getLayerName());
    }

    @Override
    public Object getLayer() {
        return this.myLayer;
    }

    @Override
    protected Vector addHandles(Vector handles) {
        LayerConnection lc = new LayerConnection();
        lc.setParam("class", "org.joone.engine.FullSynapse");
        lc.setParam("label", "F");
        handles.addElement(new ConnectionHandle(this, RelativeLocator.east(), lc));
        return handles;
    }
}

