/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import org.joone.edit.CaseAwareTextDisplay;
import org.joone.edit.JooneFileChooser;

public class JooneFileChooserEditor
extends PropertyEditorSupport
implements ActionListener {
    private JooneFileChooser fileChooser = new JooneFileChooser();
    private CaseAwareTextDisplay fileChooserPanel;

    public JooneFileChooserEditor() {
        this.fileChooser.addActionListener(this);
        this.fileChooserPanel = new CaseAwareTextDisplay();
        this.fileChooserPanel.setText("wordA wordB");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("ApproveSelection")) {
            this.setValue(this.getValue());
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        g.clipRect(box.x, box.y, box.width, box.height);
        g.translate(box.x, box.y);
        g.setColor(Color.white);
        g.fillRect(0, 0, box.width, box.height);
        g.setColor(Color.black);
        this.fileChooserPanel.paint(g);
    }

    @Override
    public void setValue(Object value) {
        File file = new File((String)value);
        this.fileChooser.setSelectedFile(file);
        this.fileChooserPanel.setText(file.getName());
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.fileChooser.getSelectedFile().getAbsolutePath();
    }

    @Override
    public Component getCustomEditor() {
        return this.fileChooser;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

