/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IniFile {
    String fileName;
    Collection cache = new ArrayList();

    public IniFile(String fileNameArg) throws IOException {
        this.fileName = fileNameArg;
        File file = new File(this.fileName);
        if (!file.exists()) {
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            pw.flush();
            pw.close();
        }
    }

    public void setParameter(String section, String item, String value) throws IOException, IllegalArgumentException {
        String line;
        if (section == null || section.trim().equals("")) {
            throw new IllegalArgumentException("Section is null or blank.");
        }
        if (item == null || item.trim().equals("")) {
            throw new IllegalArgumentException("Item is null or blank.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        this.cache = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(this.fileName));
        boolean foundSection = false;
        while ((line = br.readLine()) != null) {
            this.cache.add(line);
            if (!line.toUpperCase().equals("[" + section.toUpperCase() + "]")) continue;
            foundSection = true;
            break;
        }
        if (!foundSection) {
            this.cache.add("[" + section.toUpperCase() + "]");
            foundSection = true;
        }
        boolean foundItem = false;
        while ((line = br.readLine()) != null) {
            if (line.startsWith(item.toLowerCase() + "=")) {
                this.cache.add(item.toLowerCase() + "=" + value.toLowerCase());
                foundItem = true;
                continue;
            }
            if (line.startsWith("[") && !foundItem) {
                this.cache.add(item.toLowerCase() + "=" + value.toLowerCase());
                foundSection = false;
                foundItem = true;
            }
            this.cache.add(line);
        }
        if (!foundItem && foundSection) {
            this.cache.add(item.toLowerCase() + "=" + value.toLowerCase());
        }
        br.close();
        PrintWriter pw = new PrintWriter(new FileWriter(this.fileName));
        Iterator iter = this.cache.iterator();
        while (iter.hasNext()) {
            pw.println((String)iter.next());
        }
        pw.flush();
        pw.close();
    }

    public String getParameter(String section, String item) throws IOException, IllegalArgumentException {
        if (!this.cache.isEmpty()) {
            String result = null;
            boolean foundSection = false;
            for (String line : this.cache) {
                if (line.toUpperCase().equals("[" + section.toUpperCase() + "]")) {
                    foundSection = true;
                    continue;
                }
                if (foundSection && line.startsWith(item + "=")) {
                    result = line.substring(1 + line.indexOf("="));
                }
                if (!foundSection || !line.startsWith("[")) continue;
                break;
            }
            if (result != null) {
                return result;
            }
        } else {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(this.fileName));
            boolean foundSection = false;
            String result = null;
            while ((line = br.readLine()) != null) {
                this.cache.add(line);
                if (line.toUpperCase().equals("[" + section.toUpperCase() + "]")) {
                    foundSection = true;
                    continue;
                }
                if (foundSection && line.startsWith(item + "=")) {
                    result = line.substring(1 + line.indexOf("="));
                }
                if (!foundSection || !line.startsWith("[")) continue;
                foundSection = false;
            }
            if (result != null) {
                return result;
            }
        }
        throw new IllegalArgumentException("Section {" + section + "} item {" + item + "} not found.");
    }

    public String getParameter(String section, String item, String deflt) throws IOException {
        try {
            return this.getParameter(section, item);
        }
        catch (IllegalArgumentException e) {
            return deflt;
        }
    }

    public static void main(String[] args) {
        try {
            IniFile i = new IniFile("q.ini");
            i.setParameter("section 1", "item 1", "value 1");
            i.setParameter("sec 2", "item 2", "val 2");
            i.setParameter("section 1", "item 3", "val 3");
            System.out.println(i.getParameter("section 1", "item 3", "55"));
            System.out.println(i.getParameter("sec 2", "item 2"));
            System.out.println(i.getParameter("section 1", "item 4", "55"));
            System.out.println(i.getParameter("section 2", "item 2"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

