/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    private transient Vector fListeners = new Vector(2);
    private transient Thread fDrawingLockHolder = null;
    private static final long serialVersionUID = -2602151437447962046L;
    private int drawingSerializedDataVersion = 1;

    @Override
    public void addDrawingChangeListener(DrawingChangeListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new Vector(2);
        }
        this.fListeners.addElement(listener);
    }

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener listener) {
        this.fListeners.removeElement(listener);
    }

    @Override
    public Enumeration drawingChangeListeners() {
        return this.fListeners.elements();
    }

    @Override
    public synchronized Figure remove(Figure figure) {
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(new FigureChangeEvent(figure, null));
            return figure;
        }
        return null;
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
        Figure figure = e.getFigure();
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
        } else {
            System.out.println("Attempt to remove non-existing figure");
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener l = (DrawingChangeListener)this.fListeners.elementAt(i);
                l.drawingInvalidated(new DrawingChangeEvent(this, e.getInvalidatedRectangle()));
            }
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener l = (DrawingChangeListener)this.fListeners.elementAt(i);
                l.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    @Override
    public Vector handles() {
        Vector<NullHandle> handles = new Vector<NullHandle>();
        handles.addElement(new NullHandle(this, RelativeLocator.northWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.northEast()));
        handles.addElement(new NullHandle(this, RelativeLocator.southWest()));
        handles.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return handles;
    }

    @Override
    public Rectangle displayBox() {
        if (this.fFigures.size() > 0) {
            FigureEnumeration k = this.figures();
            Rectangle r = k.nextFigure().displayBox();
            while (k.hasMoreElements()) {
                r.add(k.nextFigure().displayBox());
            }
            return r;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    @Override
    public void basicDisplayBox(Point p1, Point p2) {
    }

    @Override
    public synchronized void lock() {
        Thread current = Thread.currentThread();
        if (this.fDrawingLockHolder == current) {
            return;
        }
        while (this.fDrawingLockHolder != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fDrawingLockHolder = current;
    }

    @Override
    public synchronized void unlock() {
        if (this.fDrawingLockHolder != null) {
            this.fDrawingLockHolder = null;
            this.notifyAll();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fListeners = new Vector(2);
    }
}

