/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import java.awt.event.MouseEvent;

public class DragTracker
extends AbstractTool {
    private Figure fAnchorFigure;
    private int fLastX;
    private int fLastY;
    private boolean fMoved = false;

    public DragTracker(DrawingView view, Figure anchor) {
        super(view);
        this.fAnchorFigure = anchor;
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.fLastX = x;
        this.fLastY = y;
        if (e.isShiftDown()) {
            this.view().toggleSelection(this.fAnchorFigure);
            this.fAnchorFigure = null;
        } else if (!this.view().selection().contains(this.fAnchorFigure)) {
            this.view().clearSelection();
            this.view().addToSelection(this.fAnchorFigure);
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        boolean bl = this.fMoved = Math.abs(x - this.fAnchorX) > 4 || Math.abs(y - this.fAnchorY) > 4;
        if (this.fMoved) {
            FigureEnumeration figures = this.view().selectionElements();
            while (figures.hasMoreElements()) {
                figures.nextFigure().moveBy(x - this.fLastX, y - this.fLastY);
            }
        }
        this.fLastX = x;
        this.fLastY = y;
    }
}

