/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.ElbowTextLocator;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import CH.ifa.draw.standard.ChangeConnectionStartHandle;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class ElbowConnection
extends LineConnection {
    private static final long serialVersionUID = 2193968743082078559L;
    private int elbowConnectionSerializedDataVersion = 1;

    @Override
    public void updateConnection() {
        super.updateConnection();
        this.updatePoints();
    }

    @Override
    public void layoutConnection() {
    }

    @Override
    public Vector handles() {
        int i;
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.fPoints.size() * 2);
        handles.addElement(new ChangeConnectionStartHandle(this));
        for (i = 1; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new NullHandle(this, ElbowConnection.locator(i)));
        }
        handles.addElement(new ChangeConnectionEndHandle(this));
        for (i = 0; i < this.fPoints.size() - 1; ++i) {
            handles.addElement(new ElbowHandle(this, i));
        }
        return handles;
    }

    @Override
    public Locator connectedTextLocator(Figure f) {
        return new ElbowTextLocator();
    }

    protected void updatePoints() {
        this.willChange();
        Point start = this.startPoint();
        Point end2 = this.endPoint();
        this.fPoints.removeAllElements();
        this.fPoints.addElement(start);
        if (start.x == end2.x || start.y == end2.y) {
            this.fPoints.addElement(end2);
        } else {
            Rectangle r1 = this.start().owner().displayBox();
            Rectangle r2 = this.end().owner().displayBox();
            int dir = Geom.direction(r1.x + r1.width / 2, r1.y + r1.height / 2, r2.x + r2.width / 2, r2.y + r2.height / 2);
            if (dir == 1 || dir == 2) {
                this.fPoints.addElement(new Point(start.x, (start.y + end2.y) / 2));
                this.fPoints.addElement(new Point(end2.x, (start.y + end2.y) / 2));
            } else {
                this.fPoints.addElement(new Point((start.x + end2.x) / 2, start.y));
                this.fPoints.addElement(new Point((start.x + end2.x) / 2, end2.y));
            }
            this.fPoints.addElement(end2);
        }
        this.changed();
    }
}

