/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.Layoutable;
import CH.ifa.draw.contrib.Layouter;
import CH.ifa.draw.contrib.StandardLayouter;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Vector;

public class GraphicalCompositeFigure
extends CompositeFigure
implements Layoutable {
    private Figure myPresentationFigure;
    private Layouter myLayouter;
    private static final long serialVersionUID = 1265742491024232713L;

    public GraphicalCompositeFigure() {
        this(new RectangleFigure());
    }

    public GraphicalCompositeFigure(Figure newPresentationFigure) {
        this.setPresentationFigure(newPresentationFigure);
        this.initialize();
    }

    protected void initialize() {
        this.setLayouter(new StandardLayouter(this));
    }

    @Override
    public Object clone() {
        Object cloneObject = super.clone();
        ((GraphicalCompositeFigure)cloneObject).initialize();
        return cloneObject;
    }

    @Override
    public Rectangle displayBox() {
        return this.getPresentationFigure().displayBox();
    }

    @Override
    public void basicDisplayBox(Point origin, Point corner) {
        Rectangle r = this.getLayouter().layout(origin, corner);
        this.getPresentationFigure().basicDisplayBox(r.getLocation(), new Point(r.width, r.height));
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        super.basicMoveBy(dx, dy);
        this.getPresentationFigure().moveBy(dx, dy);
    }

    public void update() {
        this.willChange();
        this.layout();
        this.change();
        this.changed();
    }

    @Override
    public void draw(Graphics g) {
        this.getPresentationFigure().draw(g);
        super.draw(g);
    }

    @Override
    public Vector handles() {
        return this.getPresentationFigure().handles();
    }

    @Override
    public Object getAttribute(String name) {
        if (this.getPresentationFigure() != null) {
            return this.getPresentationFigure().getAttribute(name);
        }
        return super.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.getPresentationFigure() != null) {
            this.getPresentationFigure().setAttribute(name, value);
        } else {
            super.setAttribute(name, value);
        }
    }

    public void setPresentationFigure(Figure newPresentationFigure) {
        this.myPresentationFigure = newPresentationFigure;
    }

    public Figure getPresentationFigure() {
        return this.myPresentationFigure;
    }

    @Override
    public void layout() {
        if (this.getLayouter() != null) {
            Rectangle r = this.getLayouter().calculateLayout(this.displayBox().getLocation(), this.displayBox().getLocation());
            this.displayBox(r.getLocation(), new Point(r.x + r.width, r.y + r.height));
        }
    }

    @Override
    public void setLayouter(Layouter newLayouter) {
        this.myLayouter = newLayouter;
    }

    @Override
    public Layouter getLayouter() {
        return this.myLayouter;
    }

    protected void change() {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(new FigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
        if (this.listener() != null) {
            if (this.includes(e.getFigure())) {
                this.listener().figureRequestRemove(new FigureChangeEvent(e.getFigure(), e.getInvalidatedRectangle()));
            } else {
                super.figureRequestRemove(e);
            }
        }
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setPresentationFigure((Figure)dr.readStorable());
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.getPresentationFigure());
    }
}

